/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.reactive;

import java.util.Iterator;
import java.util.concurrent.Executor;
import org.spongepowered.configurate.reactive.AbstractProcessor;
import org.spongepowered.configurate.reactive.Processor;
import org.spongepowered.configurate.reactive.RegistrationImpl;
import org.spongepowered.configurate.reactive.Subscriber;

class ProcessorImpl<V>
extends AbstractProcessor<V, RegistrationImpl<V>>
implements Processor.Iso<V> {
    ProcessorImpl(Executor exec2) {
        super(exec2);
    }

    @Override
    public void submit(V value) {
        if (this.subscriberCount.get() >= 0) {
            Subscriber fallback;
            boolean handled = false;
            Iterator it = this.registrations.iterator();
            while (it.hasNext()) {
                RegistrationImpl reg = (RegistrationImpl)it.next();
                try {
                    handled = true;
                    reg.submit(value);
                }
                catch (Exception t) {
                    it.remove();
                    this.subscriberCount.getAndDecrement();
                    reg.subscriber.onError(t);
                }
            }
            if (!handled && (fallback = this.fallbackHandler) != null) {
                fallback.submit(value);
            }
        }
    }

    @Override
    protected RegistrationImpl<V> createRegistration(Subscriber<? super V> sub) {
        return new RegistrationImpl<V>(this, sub);
    }
}

