/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.plugin.loaders.redis.util;

import com.grinderwolf.swm.internal.lettuce.core.codec.RedisCodec;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class StringByteCodec
implements RedisCodec<String, byte[]> {
    public static final StringByteCodec INSTANCE = new StringByteCodec();
    private static final byte[] EMPTY = new byte[0];
    private final Charset charset = StandardCharsets.UTF_8;

    @Override
    public String decodeKey(ByteBuffer bytes) {
        return this.charset.decode(bytes).toString();
    }

    @Override
    public byte[] decodeValue(ByteBuffer bytes) {
        return StringByteCodec.getBytes(bytes);
    }

    @Override
    public ByteBuffer encodeKey(String key) {
        return this.charset.encode(key);
    }

    @Override
    public ByteBuffer encodeValue(byte[] value) {
        if (value == null) {
            return ByteBuffer.wrap(EMPTY);
        }
        return ByteBuffer.wrap(value);
    }

    private static byte[] getBytes(ByteBuffer buffer) {
        byte[] b = new byte[buffer.remaining()];
        buffer.get(b);
        return b;
    }
}

