/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.plugin.loaders.redis;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.grinderwolf.swm.internal.lettuce.core.RedisClient;
import com.grinderwolf.swm.internal.lettuce.core.api.sync.RedisCommands;
import com.grinderwolf.swm.plugin.config.DatasourcesConfig;
import com.grinderwolf.swm.plugin.loaders.redis.util.StringByteCodec;
import com.infernalsuite.aswm.api.exceptions.UnknownWorldException;
import com.infernalsuite.aswm.api.exceptions.WorldLockedException;
import com.infernalsuite.aswm.api.loaders.SlimeLoader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class RedisLoader
implements SlimeLoader {
    private static final ScheduledExecutorService SERVICE = Executors.newScheduledThreadPool(2, new ThreadFactoryBuilder().setNameFormat("SWM Redis Lock Pool Thread #%1$d").build());
    private static final String WORLD_DATA_PREFIX = "aswm:world:data:";
    private static final String WORLD_LOCK_PREFIX = "aswm:world:lock:";
    private static final String WORLD_LIST_PREFIX = "aswm:world:list";
    private static final byte TRUE = 1;
    private final Map<String, ScheduledFuture<?>> lockedWorlds = new HashMap();
    private final RedisCommands<String, byte[]> connection;

    public RedisLoader(DatasourcesConfig.RedisConfig config) {
        this.connection = RedisClient.create(config.getUri()).connect(StringByteCodec.INSTANCE).sync();
    }

    public byte[] loadWorld(String name) throws UnknownWorldException, IOException {
        byte[] data = (byte[])this.connection.get(WORLD_DATA_PREFIX + name);
        if (data == null) {
            throw new UnknownWorldException(name);
        }
        return data;
    }

    public boolean worldExists(String name) throws IOException {
        return this.connection.exists((String[])new String[]{WORLD_DATA_PREFIX + name}) == 1L;
    }

    public List<String> listWorlds() throws IOException {
        return this.connection.smembers(WORLD_LIST_PREFIX).stream().map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8)).collect(Collectors.toList());
    }

    public void saveWorld(String worldName, byte[] bytes) throws IOException {
        this.connection.set(WORLD_DATA_PREFIX + worldName, bytes);
        this.connection.sadd(WORLD_LIST_PREFIX, (V[])new byte[][]{worldName.getBytes(StandardCharsets.UTF_8)});
    }

    public void deleteWorld(String worldName) throws UnknownWorldException, IOException {
        long deletedCount;
        ScheduledFuture<?> future = this.lockedWorlds.remove(worldName);
        if (future != null) {
            future.cancel(false);
        }
        if ((deletedCount = this.connection.del((String[])new String[]{WORLD_DATA_PREFIX + worldName, WORLD_LOCK_PREFIX + worldName}).longValue()) == 0L) {
            throw new UnknownWorldException(worldName);
        }
        this.connection.srem(WORLD_LIST_PREFIX, (V[])new byte[][]{worldName.getBytes(StandardCharsets.UTF_8)});
    }

    public void acquireLock(String worldName) throws UnknownWorldException, WorldLockedException, IOException {
        boolean wasSet = this.connection.setnx(WORLD_LOCK_PREFIX + worldName, new byte[]{1});
        if (!wasSet) {
            throw new WorldLockedException(worldName);
        }
        this.updateLock(worldName, true);
    }

    private void updateLock(String worldName, boolean forceSchedule) throws UnknownWorldException {
        boolean wasSet = this.connection.pexpire(WORLD_LOCK_PREFIX + worldName, 300000L);
        if (!wasSet) {
            throw new UnknownWorldException(worldName);
        }
        if (forceSchedule || this.lockedWorlds.containsKey(worldName)) {
            this.lockedWorlds.put(worldName, SERVICE.schedule(() -> {
                try {
                    this.updateLock(worldName, false);
                }
                catch (UnknownWorldException unknownWorldException) {
                    // empty catch block
                }
            }, 60000L, TimeUnit.MILLISECONDS));
        }
    }

    public boolean isWorldLocked(String worldName) throws UnknownWorldException, IOException {
        if (this.lockedWorlds.containsKey(worldName)) {
            return true;
        }
        return this.connection.exists((String[])new String[]{WORLD_LOCK_PREFIX + worldName}) == 1L;
    }

    public void unlockWorld(String worldName) throws UnknownWorldException, IOException {
        ScheduledFuture<?> future = this.lockedWorlds.remove(worldName);
        if (future != null) {
            future.cancel(false);
        }
        this.connection.del((String[])new String[]{WORLD_LOCK_PREFIX + worldName});
    }
}

