/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.plugin.loaders.mysql;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.grinderwolf.swm.internal.hikari.HikariConfig;
import com.grinderwolf.swm.internal.hikari.HikariDataSource;
import com.grinderwolf.swm.plugin.config.DatasourcesConfig;
import com.grinderwolf.swm.plugin.loaders.UpdatableLoader;
import com.grinderwolf.swm.plugin.log.Logging;
import com.infernalsuite.aswm.api.exceptions.UnknownWorldException;
import com.infernalsuite.aswm.api.exceptions.WorldLockedException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class MysqlLoader
extends UpdatableLoader {
    private static final ScheduledExecutorService SERVICE = Executors.newScheduledThreadPool(2, new ThreadFactoryBuilder().setNameFormat("SWM MySQL Lock Pool Thread #%1$d").build());
    private static final int CURRENT_DB_VERSION = 1;
    private static final String CREATE_VERSIONING_TABLE_QUERY = "CREATE TABLE IF NOT EXISTS `database_version` (`id` INT NOT NULL AUTO_INCREMENT, `version` INT(11), PRIMARY KEY(id));";
    private static final String INSERT_VERSION_QUERY = "INSERT INTO `database_version` (`id`, `version`) VALUES (1, ?) ON DUPLICATE KEY UPDATE `id` = ?;";
    private static final String GET_VERSION_QUERY = "SELECT `version` FROM `database_version` WHERE `id` = 1;";
    private static final String ALTER_LOCKED_COLUMN_QUERY = "ALTER TABLE `worlds` CHANGE COLUMN `locked` `locked` BIGINT NOT NULL DEFAULT 0;";
    private static final String CREATE_WORLDS_TABLE_QUERY = "CREATE TABLE IF NOT EXISTS `worlds` (`id` INT NOT NULL AUTO_INCREMENT, `name` VARCHAR(255) UNIQUE, `world` MEDIUMBLOB, `locked` BIGINT, PRIMARY KEY(id));";
    private static final String SELECT_WORLD_QUERY = "SELECT `world`, `locked` FROM `worlds` WHERE `name` = ?;";
    private static final String UPDATE_WORLD_QUERY = "INSERT INTO `worlds` (`name`, `world`, `locked`) VALUES (?, ?, 1) ON DUPLICATE KEY UPDATE `world` = ?;";
    private static final String UPDATE_LOCK_QUERY = "UPDATE `worlds` SET `locked` = ? WHERE `name` = ?;";
    private static final String DELETE_WORLD_QUERY = "DELETE FROM `worlds` WHERE `name` = ?;";
    private static final String LIST_WORLDS_QUERY = "SELECT `name` FROM `worlds`;";
    private final Map<String, ScheduledFuture> lockedWorlds = new HashMap<String, ScheduledFuture>();
    private final HikariDataSource source;

    public MysqlLoader(DatasourcesConfig.MysqlConfig config) throws SQLException {
        HikariConfig hikariConfig = new HikariConfig();
        String sqlUrl = config.getSqlUrl();
        sqlUrl = sqlUrl.replace("{host}", config.getHost());
        sqlUrl = sqlUrl.replace("{port}", String.valueOf(config.getPort()));
        sqlUrl = sqlUrl.replace("{database}", config.getDatabase());
        sqlUrl = sqlUrl.replace("{usessl}", String.valueOf(config.isUsessl()));
        hikariConfig.setJdbcUrl(sqlUrl);
        hikariConfig.setUsername(config.getUsername());
        hikariConfig.setPassword(config.getPassword());
        hikariConfig.addDataSourceProperty("cachePrepStmts", "true");
        hikariConfig.addDataSourceProperty("prepStmtCacheSize", "250");
        hikariConfig.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        hikariConfig.addDataSourceProperty("useServerPrepStmts", "true");
        hikariConfig.addDataSourceProperty("useLocalSessionState", "true");
        hikariConfig.addDataSourceProperty("rewriteBatchedStatements", "true");
        hikariConfig.addDataSourceProperty("cacheResultSetMetadata", "true");
        hikariConfig.addDataSourceProperty("cacheServerConfiguration", "true");
        hikariConfig.addDataSourceProperty("elideSetAutoCommits", "true");
        hikariConfig.addDataSourceProperty("maintainTimeStats", "false");
        this.source = new HikariDataSource(hikariConfig);
        try (Connection con = this.source.getConnection();){
            try (PreparedStatement statement = con.prepareStatement(CREATE_WORLDS_TABLE_QUERY);){
                statement.execute();
            }
            statement = con.prepareStatement(CREATE_VERSIONING_TABLE_QUERY);
            try {
                statement.execute();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    @Override
    public void update() throws IOException, UpdatableLoader.NewerDatabaseException {
        block36: {
            try (Connection con = this.source.getConnection();){
                int version;
                try (PreparedStatement statement2 = con.prepareStatement(GET_VERSION_QUERY);
                     ResultSet set2 = statement2.executeQuery();){
                    version = set2.next() ? set2.getInt(1) : -1;
                }
                if (version > 1) {
                    throw new UpdatableLoader.NewerDatabaseException(1, version);
                }
                if (version >= 1) break block36;
                Logging.warning("Your SWM MySQL database is outdated. The update process will start in 10 seconds.");
                Logging.warning("Note that this update might make your database incompatible with older SWM versions.");
                Logging.warning("Make sure no other servers with older SWM versions are using this database.");
                Logging.warning("Shut down the server to prevent your database from being updated.");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException statement2) {
                    // empty catch block
                }
                statement2 = con.prepareStatement(ALTER_LOCKED_COLUMN_QUERY);
                try {
                    statement2.executeUpdate();
                }
                finally {
                    if (statement2 != null) {
                        statement2.close();
                    }
                }
                statement2 = con.prepareStatement(INSERT_VERSION_QUERY);
                try {
                    statement2.setInt(1, 1);
                    statement2.setInt(2, 1);
                    statement2.executeUpdate();
                }
                finally {
                    if (statement2 != null) {
                        statement2.close();
                    }
                }
            }
            catch (SQLException ex) {
                throw new IOException(ex);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] loadWorld(String worldName) throws UnknownWorldException, IOException {
        try (Connection con = this.source.getConnection();){
            byte[] byArray;
            block15: {
                PreparedStatement statement = con.prepareStatement(SELECT_WORLD_QUERY);
                try {
                    statement.setString(1, worldName);
                    ResultSet set2 = statement.executeQuery();
                    if (!set2.next()) {
                        throw new UnknownWorldException(worldName);
                    }
                    byArray = set2.getBytes("world");
                    if (statement == null) break block15;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return byArray;
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean worldExists(String worldName) throws IOException {
        try (Connection con = this.source.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement statement = con.prepareStatement(SELECT_WORLD_QUERY);
                try {
                    statement.setString(1, worldName);
                    ResultSet set2 = statement.executeQuery();
                    bl = set2.next();
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    public List<String> listWorlds() throws IOException {
        ArrayList<String> worldList = new ArrayList<String>();
        try (Connection con = this.source.getConnection();
             PreparedStatement statement = con.prepareStatement(LIST_WORLDS_QUERY);){
            ResultSet set2 = statement.executeQuery();
            while (set2.next()) {
                worldList.add(set2.getString("name"));
            }
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
        return worldList;
    }

    public void saveWorld(String worldName, byte[] serializedWorld) throws IOException {
        try (Connection con = this.source.getConnection();
             PreparedStatement statement = con.prepareStatement(UPDATE_WORLD_QUERY);){
            statement.setString(1, worldName);
            statement.setBytes(2, serializedWorld);
            statement.setBytes(3, serializedWorld);
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    public void deleteWorld(String worldName) throws IOException, UnknownWorldException {
        ScheduledFuture future = this.lockedWorlds.remove(worldName);
        if (future != null) {
            future.cancel(false);
        }
        try (Connection con = this.source.getConnection();
             PreparedStatement statement = con.prepareStatement(DELETE_WORLD_QUERY);){
            statement.setString(1, worldName);
            if (statement.executeUpdate() == 0) {
                throw new UnknownWorldException(worldName);
            }
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    public void acquireLock(String worldName) throws UnknownWorldException, WorldLockedException, IOException {
        if (this.isWorldLocked(worldName)) {
            throw new WorldLockedException(worldName);
        }
        this.updateLock(worldName, true);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean isWorldLocked(String worldName) throws IOException, UnknownWorldException {
        if (this.lockedWorlds.containsKey(worldName)) {
            return true;
        }
        try (Connection con = this.source.getConnection();){
            boolean bl;
            block16: {
                PreparedStatement statement = con.prepareStatement(SELECT_WORLD_QUERY);
                try {
                    statement.setString(1, worldName);
                    ResultSet set2 = statement.executeQuery();
                    if (!set2.next()) {
                        throw new UnknownWorldException(worldName);
                    }
                    boolean bl2 = bl = System.currentTimeMillis() - set2.getLong("locked") <= 300000L;
                    if (statement == null) break block16;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    public void unlockWorld(String worldName) throws IOException, UnknownWorldException {
        ScheduledFuture future = this.lockedWorlds.remove(worldName);
        if (future != null) {
            future.cancel(false);
        }
        try (Connection con = this.source.getConnection();
             PreparedStatement statement = con.prepareStatement(UPDATE_LOCK_QUERY);){
            statement.setLong(1, 0L);
            statement.setString(2, worldName);
            if (statement.executeUpdate() == 0) {
                throw new UnknownWorldException(worldName);
            }
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    private void updateLock(String worldName, boolean forceSchedule) throws IOException {
        try (Connection con = this.source.getConnection();
             PreparedStatement statement = con.prepareStatement(UPDATE_LOCK_QUERY);){
            statement.setLong(1, System.currentTimeMillis());
            statement.setString(2, worldName);
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            Logging.error("Failed to update the lock for world " + worldName + ":");
            ex.printStackTrace();
            throw new IOException(ex);
        }
        if (forceSchedule || this.lockedWorlds.containsKey(worldName)) {
            this.lockedWorlds.put(worldName, SERVICE.schedule(() -> {
                try {
                    this.updateLock(worldName, false);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, 60000L, TimeUnit.MILLISECONDS));
        }
    }
}

