/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.plugin.loaders.file;

import com.grinderwolf.swm.plugin.log.Logging;
import com.infernalsuite.aswm.api.exceptions.UnknownWorldException;
import com.infernalsuite.aswm.api.exceptions.WorldLockedException;
import com.infernalsuite.aswm.api.loaders.SlimeLoader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.NotDirectoryException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

public class FileLoader
implements SlimeLoader {
    private static final FilenameFilter WORLD_FILE_FILTER = (dir, name) -> name.endsWith(".slime");
    private final Map<String, RandomAccessFile> worldFiles = Collections.synchronizedMap(new HashMap());
    private final File worldDir;

    public FileLoader(File worldDir) {
        this.worldDir = worldDir;
        if (worldDir.exists() && !worldDir.isDirectory()) {
            Logging.warning("A file named '" + worldDir.getName() + "' has been deleted, as this is the name used for the worlds directory.");
            worldDir.delete();
        }
        worldDir.mkdirs();
    }

    public byte[] loadWorld(String worldName) throws UnknownWorldException, IOException {
        if (!this.worldExists(worldName)) {
            throw new UnknownWorldException(worldName);
        }
        RandomAccessFile file = new RandomAccessFile(new File(this.worldDir, worldName + ".slime"), "rw");
        if (file != null && file.length() > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("World is too big!");
        }
        byte[] serializedWorld = new byte[]{};
        if (file != null) {
            serializedWorld = new byte[(int)file.length()];
            file.seek(0L);
            file.readFully(serializedWorld);
        }
        return serializedWorld;
    }

    public boolean worldExists(String worldName) {
        return new File(this.worldDir, worldName + ".slime").exists();
    }

    public List<String> listWorlds() throws NotDirectoryException {
        String[] worlds = this.worldDir.list(WORLD_FILE_FILTER);
        if (worlds == null) {
            throw new NotDirectoryException(this.worldDir.getPath());
        }
        return Arrays.stream(worlds).map(c -> c.substring(0, c.length() - 6)).collect(Collectors.toList());
    }

    public void saveWorld(String worldName, byte[] serializedWorld) throws IOException {
        boolean tempFile;
        RandomAccessFile worldFile = this.worldFiles.get(worldName);
        boolean bl = tempFile = worldFile == null;
        if (tempFile) {
            worldFile = new RandomAccessFile(new File(this.worldDir, worldName + ".slime"), "rw");
        }
        worldFile.seek(0L);
        worldFile.setLength(0L);
        worldFile.write(serializedWorld);
        worldFile.close();
    }

    public void unlockWorld(String worldName) throws UnknownWorldException, IOException {
        FileChannel channel;
        if (!this.worldExists(worldName)) {
            throw new UnknownWorldException(worldName);
        }
        RandomAccessFile file = this.worldFiles.remove(worldName);
        if (file != null && (channel = file.getChannel()).isOpen()) {
            file.close();
        }
    }

    public boolean isWorldLocked(String worldName) throws IOException {
        RandomAccessFile file = this.worldFiles.get(worldName);
        if (file == null) {
            file = new RandomAccessFile(new File(this.worldDir, worldName + ".slime"), "rw");
        }
        if (!file.getChannel().isOpen()) {
            return true;
        }
        file.close();
        return false;
    }

    public void deleteWorld(String worldName) throws UnknownWorldException {
        if (!this.worldExists(worldName)) {
            throw new UnknownWorldException(worldName);
        }
        try (RandomAccessFile randomAccessFile = this.worldFiles.get(worldName);){
            System.out.println("Deleting world.. " + worldName + ".");
            this.unlockWorld(worldName);
            FileUtils.forceDelete(new File(this.worldDir, worldName + ".slime"));
            if (randomAccessFile != null) {
                System.out.print("Attempting to delete worldData " + worldName + ".");
                randomAccessFile.seek(0L);
                randomAccessFile.setLength(0L);
                randomAccessFile.write(null);
                randomAccessFile.close();
                this.worldFiles.remove(worldName);
            }
            System.out.println("World.. " + worldName + " deleted.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void acquireLock(String worldName) throws UnknownWorldException, WorldLockedException, IOException {
        boolean tempFile;
        RandomAccessFile worldFile = this.worldFiles.get(worldName);
        boolean bl = tempFile = worldFile == null;
        if (tempFile) {
            worldFile = new RandomAccessFile(new File(this.worldDir, worldName + ".slime"), "rw");
        }
        FileChannel channel = worldFile.getChannel();
        try {
            channel.tryLock();
        }
        catch (OverlappingFileLockException ignored) {
            throw new WorldLockedException(worldName);
        }
    }
}

