/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.plugin.loaders;

import com.grinderwolf.swm.internal.lettuce.core.RedisException;
import com.grinderwolf.swm.internal.mongodb.MongoException;
import com.grinderwolf.swm.plugin.config.ConfigManager;
import com.grinderwolf.swm.plugin.config.DatasourcesConfig;
import com.grinderwolf.swm.plugin.loaders.UpdatableLoader;
import com.grinderwolf.swm.plugin.loaders.file.FileLoader;
import com.grinderwolf.swm.plugin.loaders.mongo.MongoLoader;
import com.grinderwolf.swm.plugin.loaders.mysql.MysqlLoader;
import com.grinderwolf.swm.plugin.loaders.redis.RedisLoader;
import com.grinderwolf.swm.plugin.log.Logging;
import com.infernalsuite.aswm.api.loaders.SlimeLoader;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class LoaderUtils {
    public static final long MAX_LOCK_TIME = 300000L;
    public static final long LOCK_INTERVAL = 60000L;
    private static final Map<String, SlimeLoader> loaderMap = new HashMap<String, SlimeLoader>();

    public static void registerLoaders() {
        DatasourcesConfig.RedisConfig redisConfig;
        DatasourcesConfig.MongoDBConfig mongoConfig;
        DatasourcesConfig config = ConfigManager.getDatasourcesConfig();
        DatasourcesConfig.FileConfig fileConfig = config.getFileConfig();
        LoaderUtils.registerLoader("file", new FileLoader(new File(fileConfig.getPath())));
        DatasourcesConfig.MysqlConfig mysqlConfig = config.getMysqlConfig();
        if (mysqlConfig.isEnabled()) {
            try {
                LoaderUtils.registerLoader("mysql", new MysqlLoader(mysqlConfig));
            }
            catch (SQLException ex) {
                Logging.error("Failed to establish connection to the MySQL server:");
                ex.printStackTrace();
            }
        }
        if ((mongoConfig = config.getMongoDbConfig()).isEnabled()) {
            try {
                LoaderUtils.registerLoader("mongodb", new MongoLoader(mongoConfig));
            }
            catch (MongoException ex) {
                Logging.error("Failed to establish connection to the MongoDB server:");
                ex.printStackTrace();
            }
        }
        if ((redisConfig = config.getRedisConfig()).isEnabled()) {
            try {
                LoaderUtils.registerLoader("redis", new RedisLoader(redisConfig));
            }
            catch (RedisException ex) {
                Logging.error("Failed to establish connection to the Redis server:");
                ex.printStackTrace();
            }
        }
    }

    public static List<String> getAvailableLoadersNames() {
        return new LinkedList<String>(loaderMap.keySet());
    }

    public static SlimeLoader getLoader(String dataSource) {
        return loaderMap.get(dataSource);
    }

    public static void registerLoader(String dataSource, SlimeLoader loader) {
        if (loaderMap.containsKey(dataSource)) {
            throw new IllegalArgumentException("Data source " + dataSource + " already has a declared loader!");
        }
        if (loader instanceof UpdatableLoader) {
            try {
                ((UpdatableLoader)loader).update();
            }
            catch (UpdatableLoader.NewerDatabaseException e) {
                Logging.error("Data source " + dataSource + " version is " + e.getDatabaseVersion() + ", while this SWM version only supports up to version " + e.getCurrentVersion() + ".");
                return;
            }
            catch (IOException ex) {
                Logging.error("Failed to check if data source " + dataSource + " is updated:");
                ex.printStackTrace();
                return;
            }
        }
        loaderMap.put(dataSource, loader);
    }
}

