/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.plugin.config;

import com.infernalsuite.aswm.api.world.properties.SlimeProperties;
import com.infernalsuite.aswm.api.world.properties.SlimePropertyMap;
import org.bukkit.Difficulty;
import org.bukkit.World;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Setting;

@ConfigSerializable
public class WorldData {
    @Setting(value="source")
    private String dataSource = "file";
    @Setting(value="spawn")
    private String spawn = "0.5, 255, 0.5";
    @Setting(value="difficulty")
    private String difficulty = "peaceful";
    @Setting(value="allowMonsters")
    private boolean allowMonsters = true;
    @Setting(value="allowAnimals")
    private boolean allowAnimals = true;
    @Setting(value="dragonBattle")
    private boolean dragonBattle = false;
    @Setting(value="pvp")
    private boolean pvp = true;
    @Setting(value="environment")
    private String environment = "NORMAL";
    @Setting(value="worldType")
    private String worldType = "DEFAULT";
    @Setting(value="defaultBiome")
    private String defaultBiome = "minecraft:plains";
    @Setting(value="loadOnStartup")
    private boolean loadOnStartup = true;
    @Setting(value="readOnly")
    private boolean readOnly = false;

    public SlimePropertyMap toPropertyMap() {
        double spawnZ;
        double spawnY;
        double spawnX;
        try {
            Enum.valueOf(Difficulty.class, this.difficulty.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("unknown difficulty '" + this.difficulty + "'");
        }
        String[] spawnLocationSplit = this.spawn.split(", ");
        try {
            spawnX = Double.parseDouble(spawnLocationSplit[0]);
            spawnY = Double.parseDouble(spawnLocationSplit[1]);
            spawnZ = Double.parseDouble(spawnLocationSplit[2]);
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException ex) {
            throw new IllegalArgumentException("invalid spawn location '" + this.spawn + "'");
        }
        String environment = this.environment;
        try {
            Enum.valueOf(World.Environment.class, environment.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            try {
                int envId = Integer.parseInt(environment);
                if (envId < -1 || envId > 1) {
                    throw new NumberFormatException(environment);
                }
                environment = World.Environment.getEnvironment((int)envId).name();
            }
            catch (NumberFormatException ex2) {
                throw new IllegalArgumentException("unknown environment '" + this.environment + "'");
            }
        }
        SlimePropertyMap propertyMap = new SlimePropertyMap();
        propertyMap.setValue(SlimeProperties.SPAWN_X, (Object)((int)spawnX));
        propertyMap.setValue(SlimeProperties.SPAWN_Y, (Object)((int)spawnY));
        propertyMap.setValue(SlimeProperties.SPAWN_Z, (Object)((int)spawnZ));
        propertyMap.setValue(SlimeProperties.DIFFICULTY, (Object)this.difficulty);
        propertyMap.setValue(SlimeProperties.ALLOW_MONSTERS, (Object)this.allowMonsters);
        propertyMap.setValue(SlimeProperties.ALLOW_ANIMALS, (Object)this.allowAnimals);
        propertyMap.setValue(SlimeProperties.DRAGON_BATTLE, (Object)this.dragonBattle);
        propertyMap.setValue(SlimeProperties.PVP, (Object)this.pvp);
        propertyMap.setValue(SlimeProperties.ENVIRONMENT, (Object)environment);
        propertyMap.setValue(SlimeProperties.WORLD_TYPE, (Object)this.worldType);
        propertyMap.setValue(SlimeProperties.DEFAULT_BIOME, (Object)this.defaultBiome);
        return propertyMap;
    }

    public boolean isLoadOnStartup() {
        return this.loadOnStartup;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getSpawn() {
        return this.spawn;
    }

    public void setSpawn(String spawn) {
        this.spawn = spawn;
    }

    public String getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(String difficulty) {
        this.difficulty = difficulty;
    }

    public boolean isAllowMonsters() {
        return this.allowMonsters;
    }

    public void setAllowMonsters(boolean allowMonsters) {
        this.allowMonsters = allowMonsters;
    }

    public boolean isAllowAnimals() {
        return this.allowAnimals;
    }

    public void setAllowAnimals(boolean allowAnimals) {
        this.allowAnimals = allowAnimals;
    }

    public boolean isDragonBattle() {
        return this.dragonBattle;
    }

    public void setDragonBattle(boolean dragonBattle) {
        this.dragonBattle = dragonBattle;
    }

    public boolean isPvp() {
        return this.pvp;
    }

    public void setPvp(boolean pvp) {
        this.pvp = pvp;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getWorldType() {
        return this.worldType;
    }

    public void setWorldType(String worldType) {
        this.worldType = worldType;
    }

    public String getDefaultBiome() {
        return this.defaultBiome;
    }

    public void setDefaultBiome(String defaultBiome) {
        this.defaultBiome = defaultBiome;
    }

    public void setLoadOnStartup(boolean loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
    }

    public void setReadOnly(boolean readOnly2) {
        this.readOnly = readOnly2;
    }
}

