/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.plugin.config;

import com.grinderwolf.swm.plugin.SWMPlugin;
import com.grinderwolf.swm.plugin.config.DatasourcesConfig;
import com.grinderwolf.swm.plugin.config.WorldsConfig;
import io.leangen.geantyref.TypeToken;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.loader.HeaderMode;
import org.spongepowered.configurate.yaml.NodeStyle;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public class ConfigManager {
    private static final File PLUGIN_DIR = new File("plugins", "SlimeWorldManager");
    private static final File WORLDS_FILE = new File(PLUGIN_DIR, "worlds.yml");
    private static final File SOURCES_FILE = new File(PLUGIN_DIR, "sources.yml");
    private static WorldsConfig worldConfig;
    private static YamlConfigurationLoader worldConfigLoader;
    private static DatasourcesConfig datasourcesConfig;

    public static void initialize() throws IOException {
        ConfigManager.copyDefaultConfigs();
        worldConfigLoader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().file(WORLDS_FILE)).nodeStyle(NodeStyle.BLOCK).headerMode(HeaderMode.PRESERVE)).build();
        worldConfig = ((CommentedConfigurationNode)worldConfigLoader.load()).get(TypeToken.get(WorldsConfig.class));
        YamlConfigurationLoader datasourcesConfigLoader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().file(SOURCES_FILE)).nodeStyle(NodeStyle.BLOCK).headerMode(HeaderMode.PRESERVE)).build();
        datasourcesConfig = ((CommentedConfigurationNode)datasourcesConfigLoader.load()).get(TypeToken.get(DatasourcesConfig.class));
        worldConfig.save();
        datasourcesConfigLoader.save(((CommentedConfigurationNode)datasourcesConfigLoader.createNode()).set(TypeToken.get(DatasourcesConfig.class), (Object)datasourcesConfig));
    }

    private static void copyDefaultConfigs() throws IOException {
        PLUGIN_DIR.mkdirs();
        if (!WORLDS_FILE.exists()) {
            Files.copy(SWMPlugin.getInstance().getResource("worlds.yml"), WORLDS_FILE.toPath(), new CopyOption[0]);
        }
        if (!SOURCES_FILE.exists()) {
            Files.copy(SWMPlugin.getInstance().getResource("worlds.yml"), SOURCES_FILE.toPath(), new CopyOption[0]);
        }
    }

    public static DatasourcesConfig getDatasourcesConfig() {
        return datasourcesConfig;
    }

    public static WorldsConfig getWorldConfig() {
        return worldConfig;
    }

    static YamlConfigurationLoader getWorldConfigLoader() {
        return worldConfigLoader;
    }
}

