/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.plugin;

import com.flowpowered.nbt.CompoundMap;
import com.flowpowered.nbt.CompoundTag;
import com.google.common.collect.ImmutableList;
import com.grinderwolf.swm.internal.bstats.bukkit.Metrics;
import com.grinderwolf.swm.plugin.commands.CommandManager;
import com.grinderwolf.swm.plugin.config.ConfigManager;
import com.grinderwolf.swm.plugin.config.WorldData;
import com.grinderwolf.swm.plugin.config.WorldsConfig;
import com.grinderwolf.swm.plugin.listeners.WorldUnlocker;
import com.grinderwolf.swm.plugin.loaders.LoaderUtils;
import com.grinderwolf.swm.plugin.log.Logging;
import com.infernalsuite.aswm.api.SlimeNMSBridge;
import com.infernalsuite.aswm.api.SlimePlugin;
import com.infernalsuite.aswm.api.events.LoadSlimeWorldEvent;
import com.infernalsuite.aswm.api.exceptions.CorruptedWorldException;
import com.infernalsuite.aswm.api.exceptions.InvalidWorldException;
import com.infernalsuite.aswm.api.exceptions.NewerFormatException;
import com.infernalsuite.aswm.api.exceptions.UnknownWorldException;
import com.infernalsuite.aswm.api.exceptions.WorldAlreadyExistsException;
import com.infernalsuite.aswm.api.exceptions.WorldLoadedException;
import com.infernalsuite.aswm.api.exceptions.WorldLockedException;
import com.infernalsuite.aswm.api.exceptions.WorldTooBigException;
import com.infernalsuite.aswm.api.loaders.SlimeLoader;
import com.infernalsuite.aswm.api.world.SlimeWorld;
import com.infernalsuite.aswm.api.world.SlimeWorldInstance;
import com.infernalsuite.aswm.api.world.properties.SlimePropertyMap;
import com.infernalsuite.aswm.serialization.anvil.AnvilWorldReader;
import com.infernalsuite.aswm.serialization.slime.SlimeSerializer;
import com.infernalsuite.aswm.serialization.slime.reader.SlimeWorldReaderRegistry;
import com.infernalsuite.aswm.skeleton.SkeletonSlimeWorld;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SWMPlugin
extends JavaPlugin
implements SlimePlugin,
Listener {
    private static final SlimeNMSBridge BRIDGE_INSTANCE = SlimeNMSBridge.instance();
    private final Map<String, SlimeWorld> loadedWorlds = new ConcurrentHashMap<String, SlimeWorld>();
    private static boolean isPaperMC = false;
    private static final int BSTATS_ID = 5419;

    private static boolean checkIsPaper() {
        try {
            return Class.forName("com.destroystokyo.paper.PaperConfig") != null;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public void onLoad() {
        isPaperMC = SWMPlugin.checkIsPaper();
        try {
            ConfigManager.initialize();
        }
        catch (IOException | NullPointerException ex) {
            Logging.error("Failed to load config files:");
            ex.printStackTrace();
            return;
        }
        LoaderUtils.registerLoaders();
        List<String> erroredWorlds = this.loadWorlds();
        try {
            Properties props = new Properties();
            props.load(new FileInputStream("server.properties"));
            String defaultWorldName = props.getProperty("level-name");
            if (erroredWorlds.contains(defaultWorldName)) {
                Logging.error("Shutting down server, as the default world could not be loaded.");
                Bukkit.getServer().shutdown();
            } else if (this.getServer().getAllowNether() && erroredWorlds.contains(defaultWorldName + "_nether")) {
                Logging.error("Shutting down server, as the default nether world could not be loaded.");
                Bukkit.getServer().shutdown();
            } else if (this.getServer().getAllowEnd() && erroredWorlds.contains(defaultWorldName + "_the_end")) {
                Logging.error("Shutting down server, as the default end world could not be loaded.");
                Bukkit.getServer().shutdown();
            }
            SlimeWorld defaultWorld = this.loadedWorlds.get(defaultWorldName);
            SlimeWorld netherWorld = this.getServer().getAllowNether() ? this.loadedWorlds.get(defaultWorldName + "_nether") : null;
            SlimeWorld endWorld = this.getServer().getAllowEnd() ? this.loadedWorlds.get(defaultWorldName + "_the_end") : null;
            BRIDGE_INSTANCE.setDefaultWorlds(defaultWorld, netherWorld, endWorld);
        }
        catch (IOException ex) {
            Logging.error("Failed to retrieve default world name:");
            ex.printStackTrace();
        }
    }

    public void onEnable() {
        if (BRIDGE_INSTANCE == null) {
            this.setEnabled(false);
            return;
        }
        Metrics metrics = new Metrics(this, 5419);
        CommandManager commandManager = new CommandManager();
        PluginCommand swmCommand = this.getCommand("swm");
        swmCommand.setExecutor((CommandExecutor)commandManager);
        try {
            swmCommand.setTabCompleter((TabCompleter)commandManager);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.loadedWorlds.values().stream().filter(slimeWorld -> Objects.isNull(Bukkit.getWorld((String)slimeWorld.getName()))).forEach(this::loadWorld);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldUnlocker(), (Plugin)this);
    }

    public void onDisable() {
    }

    private List<String> loadWorlds() {
        ArrayList<String> erroredWorlds = new ArrayList<String>();
        WorldsConfig config = ConfigManager.getWorldConfig();
        for (Map.Entry<String, WorldData> entry : config.getWorlds().entrySet()) {
            String worldName = entry.getKey();
            WorldData worldData = entry.getValue();
            if (!worldData.isLoadOnStartup()) continue;
            try {
                SlimeLoader loader = this.getLoader(worldData.getDataSource());
                if (loader == null) {
                    throw new IllegalArgumentException("invalid data source " + worldData.getDataSource());
                }
                SlimePropertyMap propertyMap = worldData.toPropertyMap();
                SlimeWorld world = this.loadWorld(loader, worldName, worldData.isReadOnly(), propertyMap);
                this.loadedWorlds.put(worldName, world);
            }
            catch (CorruptedWorldException | NewerFormatException | UnknownWorldException | WorldLockedException | IOException | IllegalArgumentException ex) {
                Object message;
                if (ex instanceof IllegalArgumentException) {
                    message = ex.getMessage();
                    ex.printStackTrace();
                } else if (ex instanceof UnknownWorldException) {
                    message = "world does not exist, are you sure you've set the correct data source?";
                } else if (ex instanceof WorldLockedException) {
                    message = "world is in use! If you think this is a mistake, please wait some time and try again.";
                } else if (ex instanceof NewerFormatException) {
                    message = "world is serialized in a newer Slime Format version (" + ex.getMessage() + ") that SWM does not understand.";
                } else if (ex instanceof CorruptedWorldException) {
                    message = "world seems to be corrupted.";
                } else {
                    message = "";
                    ex.printStackTrace();
                }
                Logging.error("Failed to load world " + worldName + (String)(((String)message).isEmpty() ? "." : ": " + (String)message));
                erroredWorlds.add(worldName);
            }
        }
        config.save();
        return erroredWorlds;
    }

    public SlimeWorld loadWorld(SlimeLoader loader, String worldName, boolean readOnly2, SlimePropertyMap propertyMap) throws UnknownWorldException, IOException, CorruptedWorldException, NewerFormatException, WorldLockedException {
        Objects.requireNonNull(loader, "Loader cannot be null");
        Objects.requireNonNull(worldName, "World name cannot be null");
        Objects.requireNonNull(propertyMap, "Properties cannot be null");
        long start = System.currentTimeMillis();
        Logging.info("Loading world " + worldName + ".");
        byte[] serializedWorld = loader.loadWorld(worldName);
        SlimeWorld slimeWorld = SlimeWorldReaderRegistry.readWorld((SlimeLoader)loader, (String)worldName, (byte[])serializedWorld, (SlimePropertyMap)propertyMap, (boolean)readOnly2);
        Logging.info("Applying datafixers for " + worldName + ".");
        SlimeNMSBridge.instance().applyDataFixers(slimeWorld);
        Logging.info("World " + worldName + " loaded in " + (System.currentTimeMillis() - start) + "ms.");
        this.registerWorld(slimeWorld);
        return slimeWorld;
    }

    public SlimeWorld getWorld(String worldName) {
        return this.loadedWorlds.get(worldName);
    }

    public List<SlimeWorld> getLoadedWorlds() {
        return ImmutableList.copyOf(this.loadedWorlds.values());
    }

    public SlimeWorld createEmptyWorld(SlimeLoader loader, String worldName, boolean readOnly2, SlimePropertyMap propertyMap) throws WorldAlreadyExistsException, IOException {
        Objects.requireNonNull(loader, "Loader cannot be null");
        Objects.requireNonNull(worldName, "World name cannot be null");
        Objects.requireNonNull(propertyMap, "Properties cannot be null");
        if (loader.worldExists(worldName)) {
            throw new WorldAlreadyExistsException(worldName);
        }
        Logging.info("Creating empty world " + worldName + ".");
        long start = System.currentTimeMillis();
        SkeletonSlimeWorld blackhole = new SkeletonSlimeWorld(worldName, loader, readOnly2, Map.of(), new CompoundTag("", new CompoundMap()), propertyMap, BRIDGE_INSTANCE.getCurrentVersion());
        loader.saveWorld(worldName, SlimeSerializer.serialize((SlimeWorld)blackhole));
        Logging.info("World " + worldName + " created in " + (System.currentTimeMillis() - start) + "ms.");
        this.registerWorld((SlimeWorld)blackhole);
        return blackhole;
    }

    private void registerWorld(SlimeWorld world) {
        this.loadedWorlds.put(world.getName(), world);
    }

    @EventHandler
    public void onBukkitWorldUnload(WorldUnloadEvent worldUnloadEvent) {
        this.loadedWorlds.remove(worldUnloadEvent.getWorld().getName());
    }

    public SlimeWorld loadWorld(SlimeWorld slimeWorld) {
        Objects.requireNonNull(slimeWorld, "SlimeWorld cannot be null");
        SlimeWorldInstance instance = BRIDGE_INSTANCE.loadInstance(slimeWorld);
        SlimeWorld mirror = instance.getSlimeWorldMirror();
        Bukkit.getPluginManager().callEvent((Event)new LoadSlimeWorldEvent(mirror));
        this.registerWorld(mirror);
        if (!slimeWorld.isReadOnly() && slimeWorld.getLoader() != null) {
            try {
                slimeWorld.getLoader().acquireLock(slimeWorld.getName());
            }
            catch (UnknownWorldException | WorldLockedException | IOException e) {
                e.printStackTrace();
            }
        }
        return mirror;
    }

    public void migrateWorld(String worldName, SlimeLoader currentLoader, SlimeLoader newLoader) throws IOException, WorldAlreadyExistsException, UnknownWorldException {
        Objects.requireNonNull(worldName, "World name cannot be null");
        Objects.requireNonNull(currentLoader, "Current loader cannot be null");
        Objects.requireNonNull(newLoader, "New loader cannot be null");
        if (newLoader.worldExists(worldName)) {
            throw new WorldAlreadyExistsException(worldName);
        }
        byte[] serializedWorld = currentLoader.loadWorld(worldName);
        newLoader.saveWorld(worldName, serializedWorld);
        currentLoader.deleteWorld(worldName);
    }

    public SlimeLoader getLoader(String dataSource) {
        Objects.requireNonNull(dataSource, "Data source cannot be null");
        return LoaderUtils.getLoader(dataSource);
    }

    public void registerLoader(String dataSource, SlimeLoader loader) {
        Objects.requireNonNull(dataSource, "Data source cannot be null");
        Objects.requireNonNull(loader, "Loader cannot be null");
        LoaderUtils.registerLoader(dataSource, loader);
    }

    public void importWorld(File worldDir, String worldName, SlimeLoader loader) throws WorldAlreadyExistsException, InvalidWorldException, WorldLoadedException, WorldTooBigException, IOException {
        byte[] serializedWorld;
        Objects.requireNonNull(worldDir, "World directory cannot be null");
        Objects.requireNonNull(worldName, "World name cannot be null");
        Objects.requireNonNull(loader, "Loader cannot be null");
        if (loader.worldExists(worldName)) {
            throw new WorldAlreadyExistsException(worldName);
        }
        World bukkitWorld = Bukkit.getWorld((String)worldDir.getName());
        if (bukkitWorld != null && BRIDGE_INSTANCE.getInstance(bukkitWorld) == null) {
            throw new WorldLoadedException(worldDir.getName());
        }
        SlimeWorld world = AnvilWorldReader.INSTANCE.readFromData(worldDir);
        try {
            serializedWorld = SlimeSerializer.serialize((SlimeWorld)world);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new WorldTooBigException(worldDir.getName());
        }
        loader.saveWorld(worldName, serializedWorld);
    }

    public static boolean isPaperMC() {
        return isPaperMC;
    }

    public static SWMPlugin getInstance() {
        return (SWMPlugin)SWMPlugin.getPlugin(SWMPlugin.class);
    }

    private void runAsync(Runnable runnable) {
        this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, runnable);
    }
}

