/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.mongodb.util;

import com.grinderwolf.swm.internal.bson.util.ClassMap;
import com.grinderwolf.swm.internal.mongodb.Bytes;
import com.grinderwolf.swm.internal.mongodb.util.AbstractObjectSerializer;
import com.grinderwolf.swm.internal.mongodb.util.ObjectSerializer;
import java.util.Iterator;
import java.util.List;

class ClassMapBasedObjectSerializer
extends AbstractObjectSerializer {
    private final ClassMap<ObjectSerializer> _serializers = new ClassMap();

    ClassMapBasedObjectSerializer() {
    }

    void addObjectSerializer(Class c, ObjectSerializer serializer) {
        this._serializers.put(c, serializer);
    }

    @Override
    public void serialize(Object obj, StringBuilder buf) {
        Class<?> ancestor;
        Object objectToSerialize = obj;
        if ((objectToSerialize = Bytes.applyEncodingHooks(objectToSerialize)) == null) {
            buf.append(" null ");
            return;
        }
        ObjectSerializer serializer = null;
        List<Class<?>> ancestors = ClassMap.getAncestry(objectToSerialize.getClass());
        Iterator<Class<?>> iterator = ancestors.iterator();
        while (iterator.hasNext() && (serializer = this._serializers.get(ancestor = iterator.next())) == null) {
        }
        if (serializer == null && objectToSerialize.getClass().isArray()) {
            serializer = this._serializers.get(Object[].class);
        }
        if (serializer == null) {
            throw new RuntimeException("json can't serialize type : " + objectToSerialize.getClass());
        }
        serializer.serialize(objectToSerialize, buf);
    }
}

