/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.mongodb.operation;

import com.grinderwolf.swm.internal.bson.BsonDocument;
import com.grinderwolf.swm.internal.bson.BsonInt32;
import com.grinderwolf.swm.internal.mongodb.operation.MapReduceStatistics;

final class MapReduceHelper {
    static MapReduceStatistics createStatistics(BsonDocument result) {
        return new MapReduceStatistics(MapReduceHelper.getInputCount(result), MapReduceHelper.getOutputCount(result), MapReduceHelper.getEmitCount(result), MapReduceHelper.getDuration(result));
    }

    private static int getInputCount(BsonDocument result) {
        return result.getDocument("counts", new BsonDocument()).getNumber("input", new BsonInt32(0)).intValue();
    }

    private static int getOutputCount(BsonDocument result) {
        return result.getDocument("counts", new BsonDocument()).getNumber("output", new BsonInt32(0)).intValue();
    }

    private static int getEmitCount(BsonDocument result) {
        return result.getDocument("counts", new BsonDocument()).getNumber("emit", new BsonInt32(0)).intValue();
    }

    private static int getDuration(BsonDocument result) {
        return result.getNumber("timeMillis", new BsonInt32(0)).intValue();
    }

    private MapReduceHelper() {
    }
}

