/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.mongodb.operation;

import com.grinderwolf.swm.internal.bson.BsonBoolean;
import com.grinderwolf.swm.internal.bson.BsonDocument;
import com.grinderwolf.swm.internal.bson.BsonInt32;
import com.grinderwolf.swm.internal.mongodb.MongoWriteConcernException;
import com.grinderwolf.swm.internal.mongodb.ServerAddress;
import com.grinderwolf.swm.internal.mongodb.WriteConcernResult;
import com.grinderwolf.swm.internal.mongodb.connection.AsyncConnection;
import com.grinderwolf.swm.internal.mongodb.connection.Connection;
import com.grinderwolf.swm.internal.mongodb.internal.operation.WriteConcernHelper;
import com.grinderwolf.swm.internal.mongodb.operation.BsonDocumentWrapperHelper;
import com.grinderwolf.swm.internal.mongodb.operation.CommandOperationHelper;

final class FindAndModifyHelper {
    static <T> CommandOperationHelper.CommandWriteTransformer<BsonDocument, T> transformer() {
        return new CommandOperationHelper.CommandWriteTransformer<BsonDocument, T>(){

            @Override
            public T apply(BsonDocument result, Connection connection) {
                return FindAndModifyHelper.transformDocument(result, connection.getDescription().getServerAddress());
            }
        };
    }

    static <T> CommandOperationHelper.CommandWriteTransformerAsync<BsonDocument, T> asyncTransformer() {
        return new CommandOperationHelper.CommandWriteTransformerAsync<BsonDocument, T>(){

            @Override
            public T apply(BsonDocument result, AsyncConnection connection) {
                return FindAndModifyHelper.transformDocument(result, connection.getDescription().getServerAddress());
            }
        };
    }

    private static <T> T transformDocument(BsonDocument result, ServerAddress serverAddress) {
        if (WriteConcernHelper.hasWriteConcernError(result)) {
            throw new MongoWriteConcernException(WriteConcernHelper.createWriteConcernError(result.getDocument("writeConcernError")), FindAndModifyHelper.createWriteConcernResult(result.getDocument("lastErrorObject", new BsonDocument())), serverAddress);
        }
        if (!result.isDocument("value")) {
            return null;
        }
        return BsonDocumentWrapperHelper.toDocument(result.getDocument("value", null));
    }

    private static WriteConcernResult createWriteConcernResult(BsonDocument result) {
        BsonBoolean updatedExisting = result.getBoolean("updatedExisting", BsonBoolean.FALSE);
        return WriteConcernResult.acknowledged(result.getNumber("n", new BsonInt32(0)).intValue(), updatedExisting.getValue(), result.get("upserted"));
    }

    private FindAndModifyHelper() {
    }
}

