/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.mongodb.operation;

import com.grinderwolf.swm.internal.bson.BsonDocument;
import com.grinderwolf.swm.internal.bson.BsonDocumentWrapper;
import com.grinderwolf.swm.internal.bson.BsonReader;
import com.grinderwolf.swm.internal.bson.BsonType;
import com.grinderwolf.swm.internal.bson.BsonValue;
import com.grinderwolf.swm.internal.bson.codecs.BsonDocumentCodec;
import com.grinderwolf.swm.internal.bson.codecs.Codec;
import com.grinderwolf.swm.internal.bson.codecs.Decoder;
import com.grinderwolf.swm.internal.bson.codecs.DecoderContext;
import com.grinderwolf.swm.internal.bson.codecs.configuration.CodecRegistries;
import com.grinderwolf.swm.internal.bson.codecs.configuration.CodecRegistry;
import com.grinderwolf.swm.internal.mongodb.operation.CommandResultArrayCodec;
import com.grinderwolf.swm.internal.mongodb.operation.CommandResultCodecProvider;
import java.util.Collections;
import java.util.List;

class CommandResultDocumentCodec<T>
extends BsonDocumentCodec {
    private final Decoder<T> payloadDecoder;
    private final List<String> fieldsContainingPayload;

    CommandResultDocumentCodec(CodecRegistry registry, Decoder<T> payloadDecoder, List<String> fieldsContainingPayload) {
        super(registry);
        this.payloadDecoder = payloadDecoder;
        this.fieldsContainingPayload = fieldsContainingPayload;
    }

    static <P> Codec<BsonDocument> create(Decoder<P> decoder, String fieldContainingPayload) {
        return CommandResultDocumentCodec.create(decoder, Collections.singletonList(fieldContainingPayload));
    }

    static <P> Codec<BsonDocument> create(Decoder<P> decoder, List<String> fieldsContainingPayload) {
        CodecRegistry registry = CodecRegistries.fromProviders(new CommandResultCodecProvider<P>(decoder, fieldsContainingPayload));
        return registry.get(BsonDocument.class);
    }

    @Override
    protected BsonValue readValue(BsonReader reader, DecoderContext decoderContext) {
        if (this.fieldsContainingPayload.contains(reader.getCurrentName())) {
            if (reader.getCurrentBsonType() == BsonType.DOCUMENT) {
                return new BsonDocumentWrapper<T>(this.payloadDecoder.decode(reader, decoderContext), null);
            }
            if (reader.getCurrentBsonType() == BsonType.ARRAY) {
                return new CommandResultArrayCodec<T>(this.getCodecRegistry(), this.payloadDecoder).decode(reader, decoderContext);
            }
        }
        return super.readValue(reader, decoderContext);
    }
}

