/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.mongodb.operation;

import com.grinderwolf.swm.internal.bson.BsonDocument;
import com.grinderwolf.swm.internal.bson.BsonInt64;
import com.grinderwolf.swm.internal.bson.FieldNameValidator;
import com.grinderwolf.swm.internal.bson.codecs.Decoder;
import com.grinderwolf.swm.internal.mongodb.MongoNamespace;
import com.grinderwolf.swm.internal.mongodb.WriteConcern;
import com.grinderwolf.swm.internal.mongodb.assertions.Assertions;
import com.grinderwolf.swm.internal.mongodb.async.SingleResultCallback;
import com.grinderwolf.swm.internal.mongodb.binding.AsyncWriteBinding;
import com.grinderwolf.swm.internal.mongodb.binding.WriteBinding;
import com.grinderwolf.swm.internal.mongodb.connection.ConnectionDescription;
import com.grinderwolf.swm.internal.mongodb.connection.ServerDescription;
import com.grinderwolf.swm.internal.mongodb.internal.operation.ServerVersionHelper;
import com.grinderwolf.swm.internal.mongodb.operation.AsyncWriteOperation;
import com.grinderwolf.swm.internal.mongodb.operation.CommandOperationHelper;
import com.grinderwolf.swm.internal.mongodb.operation.CommandResultDocumentCodec;
import com.grinderwolf.swm.internal.mongodb.operation.FindAndModifyHelper;
import com.grinderwolf.swm.internal.mongodb.operation.OperationHelper;
import com.grinderwolf.swm.internal.mongodb.operation.WriteOperation;
import com.grinderwolf.swm.internal.mongodb.session.SessionContext;

@Deprecated
public abstract class BaseFindAndModifyOperation<T>
implements AsyncWriteOperation<T>,
WriteOperation<T> {
    private final MongoNamespace namespace;
    private final WriteConcern writeConcern;
    private final boolean retryWrites;
    private final Decoder<T> decoder;

    protected BaseFindAndModifyOperation(MongoNamespace namespace, WriteConcern writeConcern, boolean retryWrites, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.retryWrites = retryWrites;
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    @Override
    public T execute(WriteBinding binding) {
        return CommandOperationHelper.executeRetryableCommand(binding, this.getDatabaseName(), null, this.getFieldNameValidator(), CommandResultDocumentCodec.create(this.getDecoder(), "value"), this.getCommandCreator(binding.getSessionContext()), FindAndModifyHelper.<BsonDocument>transformer());
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<T> callback) {
        CommandOperationHelper.executeRetryableCommand(binding, this.getDatabaseName(), null, this.getFieldNameValidator(), CommandResultDocumentCodec.create(this.getDecoder(), "value"), this.getCommandCreator(binding.getSessionContext()), FindAndModifyHelper.<BsonDocument>asyncTransformer(), callback);
    }

    protected abstract String getDatabaseName();

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public boolean isRetryWrites() {
        return this.retryWrites;
    }

    protected abstract CommandOperationHelper.CommandCreator getCommandCreator(SessionContext var1);

    protected void addTxnNumberToCommand(ServerDescription serverDescription, ConnectionDescription connectionDescription, BsonDocument commandDocument, SessionContext sessionContext) {
        if (OperationHelper.isRetryableWrite(this.isRetryWrites(), this.getWriteConcern(), serverDescription, connectionDescription, sessionContext)) {
            commandDocument.put("txnNumber", new BsonInt64(sessionContext.advanceTransactionNumber()));
        }
    }

    protected void addWriteConcernToCommand(ConnectionDescription connectionDescription, BsonDocument commandDocument, SessionContext sessionContext) {
        if (this.getWriteConcern().isAcknowledged() && !this.getWriteConcern().isServerDefault() && ServerVersionHelper.serverIsAtLeastVersionThreeDotTwo(connectionDescription) && !sessionContext.hasActiveTransaction()) {
            commandDocument.put("writeConcern", this.getWriteConcern().asDocument());
        }
    }

    protected abstract FieldNameValidator getFieldNameValidator();
}

