/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.mongodb.internal.connection;

import com.grinderwolf.swm.internal.bson.BsonDocument;
import com.grinderwolf.swm.internal.bson.io.BsonOutput;
import com.grinderwolf.swm.internal.mongodb.internal.connection.BaseQueryMessage;
import com.grinderwolf.swm.internal.mongodb.internal.connection.MessageSettings;
import com.grinderwolf.swm.internal.mongodb.internal.connection.RequestMessage;
import com.grinderwolf.swm.internal.mongodb.internal.validator.NoOpFieldNameValidator;

class QueryMessage
extends BaseQueryMessage {
    private final BsonDocument queryDocument;
    private final BsonDocument fields;

    QueryMessage(String collectionName, int skip, int numberToReturn, BsonDocument queryDocument, BsonDocument fields, MessageSettings settings) {
        super(collectionName, skip, numberToReturn, settings);
        this.queryDocument = queryDocument;
        this.fields = fields;
    }

    @Override
    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput bsonOutput) {
        this.writeQueryPrologue(bsonOutput);
        int firstDocumentStartPosition = bsonOutput.getPosition();
        this.addDocument(this.queryDocument, bsonOutput, new NoOpFieldNameValidator());
        if (this.fields != null) {
            this.addDocument(this.fields, bsonOutput, new NoOpFieldNameValidator());
        }
        return new RequestMessage.EncodingMetadata(firstDocumentStartPosition);
    }
}

