/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.mongodb.internal.connection;

import com.grinderwolf.swm.internal.bson.BsonDocument;
import com.grinderwolf.swm.internal.mongodb.MongoCompressor;
import com.grinderwolf.swm.internal.mongodb.MongoDriverInformation;
import com.grinderwolf.swm.internal.mongodb.assertions.Assertions;
import com.grinderwolf.swm.internal.mongodb.connection.ServerId;
import com.grinderwolf.swm.internal.mongodb.connection.StreamFactory;
import com.grinderwolf.swm.internal.mongodb.event.CommandListener;
import com.grinderwolf.swm.internal.mongodb.internal.connection.Authenticator;
import com.grinderwolf.swm.internal.mongodb.internal.connection.ClientMetadataHelper;
import com.grinderwolf.swm.internal.mongodb.internal.connection.DefaultAuthenticator;
import com.grinderwolf.swm.internal.mongodb.internal.connection.GSSAPIAuthenticator;
import com.grinderwolf.swm.internal.mongodb.internal.connection.InternalConnection;
import com.grinderwolf.swm.internal.mongodb.internal.connection.InternalConnectionFactory;
import com.grinderwolf.swm.internal.mongodb.internal.connection.InternalStreamConnection;
import com.grinderwolf.swm.internal.mongodb.internal.connection.InternalStreamConnectionInitializer;
import com.grinderwolf.swm.internal.mongodb.internal.connection.MongoCredentialWithCache;
import com.grinderwolf.swm.internal.mongodb.internal.connection.NativeAuthenticator;
import com.grinderwolf.swm.internal.mongodb.internal.connection.PlainAuthenticator;
import com.grinderwolf.swm.internal.mongodb.internal.connection.ScramShaAuthenticator;
import com.grinderwolf.swm.internal.mongodb.internal.connection.X509Authenticator;
import java.util.ArrayList;
import java.util.List;

class InternalStreamConnectionFactory
implements InternalConnectionFactory {
    private final StreamFactory streamFactory;
    private final BsonDocument clientMetadataDocument;
    private final List<Authenticator> authenticators;
    private final List<MongoCompressor> compressorList;
    private final CommandListener commandListener;

    InternalStreamConnectionFactory(StreamFactory streamFactory, List<MongoCredentialWithCache> credentialList, String applicationName, MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, CommandListener commandListener) {
        this.streamFactory = Assertions.notNull("streamFactory", streamFactory);
        this.compressorList = Assertions.notNull("compressorList", compressorList);
        this.commandListener = commandListener;
        this.clientMetadataDocument = ClientMetadataHelper.createClientMetadataDocument(applicationName, mongoDriverInformation);
        Assertions.notNull("credentialList", credentialList);
        this.authenticators = new ArrayList<Authenticator>(credentialList.size());
        for (MongoCredentialWithCache credential : credentialList) {
            this.authenticators.add(this.createAuthenticator(credential));
        }
    }

    @Override
    public InternalConnection create(ServerId serverId) {
        return new InternalStreamConnection(serverId, this.streamFactory, this.compressorList, this.commandListener, new InternalStreamConnectionInitializer(this.authenticators, this.clientMetadataDocument, this.compressorList));
    }

    private Authenticator createAuthenticator(MongoCredentialWithCache credential) {
        if (credential.getAuthenticationMechanism() == null) {
            return new DefaultAuthenticator(credential);
        }
        switch (credential.getAuthenticationMechanism()) {
            case GSSAPI: {
                return new GSSAPIAuthenticator(credential);
            }
            case PLAIN: {
                return new PlainAuthenticator(credential);
            }
            case MONGODB_X509: {
                return new X509Authenticator(credential);
            }
            case SCRAM_SHA_1: 
            case SCRAM_SHA_256: {
                return new ScramShaAuthenticator(credential);
            }
            case MONGODB_CR: {
                return new NativeAuthenticator(credential);
            }
        }
        throw new IllegalArgumentException("Unsupported authentication mechanism " + (Object)((Object)credential.getAuthenticationMechanism()));
    }
}

