/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.mongodb.internal.connection;

import com.grinderwolf.swm.internal.bson.io.BsonOutput;
import com.grinderwolf.swm.internal.mongodb.bulk.InsertRequest;
import com.grinderwolf.swm.internal.mongodb.internal.connection.LegacyMessage;
import com.grinderwolf.swm.internal.mongodb.internal.connection.MessageSettings;
import com.grinderwolf.swm.internal.mongodb.internal.connection.OpCode;
import com.grinderwolf.swm.internal.mongodb.internal.connection.RequestMessage;
import com.grinderwolf.swm.internal.mongodb.internal.validator.CollectibleDocumentFieldNameValidator;

class InsertMessage
extends LegacyMessage {
    private final InsertRequest insertRequest;

    InsertMessage(String collectionName, InsertRequest insertRequest, MessageSettings settings) {
        super(collectionName, OpCode.OP_INSERT, settings);
        this.insertRequest = insertRequest;
    }

    @Override
    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput outputStream) {
        this.writeInsertPrologue(outputStream);
        int firstDocumentPosition = outputStream.getPosition();
        this.addCollectibleDocument(this.insertRequest.getDocument(), outputStream, new CollectibleDocumentFieldNameValidator());
        return new RequestMessage.EncodingMetadata(firstDocumentPosition);
    }

    private void writeInsertPrologue(BsonOutput outputStream) {
        outputStream.writeInt32(0);
        outputStream.writeCString(this.getCollectionName());
    }
}

