/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.mongodb.internal.connection;

import com.grinderwolf.swm.internal.bson.BsonBinaryWriter;
import com.grinderwolf.swm.internal.bson.BsonElement;
import com.grinderwolf.swm.internal.bson.BsonReader;
import com.grinderwolf.swm.internal.mongodb.internal.connection.BsonWriterHelper;
import com.grinderwolf.swm.internal.mongodb.internal.connection.LevelCountingBsonWriter;
import java.util.List;

public class ElementExtendingBsonWriter
extends LevelCountingBsonWriter {
    private final List<BsonElement> extraElements;

    public ElementExtendingBsonWriter(BsonBinaryWriter writer, List<BsonElement> extraElements) {
        super(writer);
        this.extraElements = extraElements;
    }

    @Override
    public void writeEndDocument() {
        if (this.getCurrentLevel() == 0) {
            BsonWriterHelper.writeElements(this.getBsonBinaryWriter(), this.extraElements);
        }
        super.writeEndDocument();
    }

    @Override
    public void pipe(BsonReader reader) {
        if (this.getCurrentLevel() == -1) {
            this.getBsonBinaryWriter().pipe(reader, this.extraElements);
        } else {
            this.getBsonBinaryWriter().pipe(reader);
        }
    }
}

