/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.mongodb.internal.connection;

import com.grinderwolf.swm.internal.mongodb.MongoException;
import com.grinderwolf.swm.internal.mongodb.ServerAddress;
import com.grinderwolf.swm.internal.mongodb.assertions.Assertions;
import com.grinderwolf.swm.internal.mongodb.connection.ClusterId;
import com.grinderwolf.swm.internal.mongodb.connection.ClusterSettings;
import com.grinderwolf.swm.internal.mongodb.connection.ClusterType;
import com.grinderwolf.swm.internal.mongodb.internal.connection.AbstractMultiServerCluster;
import com.grinderwolf.swm.internal.mongodb.internal.connection.ClusterableServerFactory;
import com.grinderwolf.swm.internal.mongodb.internal.connection.DnsSrvRecordInitializer;
import com.grinderwolf.swm.internal.mongodb.internal.connection.DnsSrvRecordMonitor;
import com.grinderwolf.swm.internal.mongodb.internal.connection.DnsSrvRecordMonitorFactory;
import java.util.Collection;
import java.util.Collections;

public final class DnsMultiServerCluster
extends AbstractMultiServerCluster {
    private final DnsSrvRecordMonitor dnsSrvRecordMonitor;
    private volatile MongoException srvResolutionException;

    public DnsMultiServerCluster(ClusterId clusterId, ClusterSettings settings, ClusterableServerFactory serverFactory, DnsSrvRecordMonitorFactory dnsSrvRecordMonitorFactory) {
        super(clusterId, settings, serverFactory);
        Assertions.notNull("srvHost", settings.getSrvHost());
        this.dnsSrvRecordMonitor = dnsSrvRecordMonitorFactory.create(settings.getSrvHost(), new DnsSrvRecordInitializer(){
            private volatile boolean initialized;

            @Override
            public void initialize(Collection<ServerAddress> hosts) {
                DnsMultiServerCluster.this.srvResolutionException = null;
                if (!this.initialized) {
                    this.initialized = true;
                    DnsMultiServerCluster.this.initialize(hosts);
                } else {
                    DnsMultiServerCluster.this.onChange(hosts);
                }
            }

            @Override
            public void initialize(MongoException initializationException) {
                if (!this.initialized) {
                    DnsMultiServerCluster.this.srvResolutionException = initializationException;
                    DnsMultiServerCluster.this.initialize(Collections.<ServerAddress>emptyList());
                }
            }

            @Override
            public ClusterType getClusterType() {
                return DnsMultiServerCluster.this.getClusterType();
            }
        });
        this.dnsSrvRecordMonitor.start();
    }

    @Override
    protected MongoException getSrvResolutionException() {
        return this.srvResolutionException;
    }

    @Override
    public void close() {
        if (this.dnsSrvRecordMonitor != null) {
            this.dnsSrvRecordMonitor.close();
        }
        super.close();
    }
}

