/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.mongodb.internal.connection;

import com.grinderwolf.swm.internal.bson.io.BsonOutput;
import com.grinderwolf.swm.internal.mongodb.bulk.DeleteRequest;
import com.grinderwolf.swm.internal.mongodb.internal.connection.LegacyMessage;
import com.grinderwolf.swm.internal.mongodb.internal.connection.MessageSettings;
import com.grinderwolf.swm.internal.mongodb.internal.connection.OpCode;
import com.grinderwolf.swm.internal.mongodb.internal.connection.RequestMessage;
import com.grinderwolf.swm.internal.mongodb.internal.validator.NoOpFieldNameValidator;

class DeleteMessage
extends LegacyMessage {
    private final DeleteRequest deleteRequest;

    DeleteMessage(String collectionName, DeleteRequest deleteRequest, MessageSettings settings) {
        super(collectionName, OpCode.OP_DELETE, settings);
        this.deleteRequest = deleteRequest;
    }

    @Override
    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput bsonOutput) {
        bsonOutput.writeInt32(0);
        bsonOutput.writeCString(this.getCollectionName());
        if (this.deleteRequest.isMulti()) {
            bsonOutput.writeInt32(0);
        } else {
            bsonOutput.writeInt32(1);
        }
        int firstDocumentStartPosition = bsonOutput.getPosition();
        this.addDocument(this.deleteRequest.getFilter(), bsonOutput, new NoOpFieldNameValidator());
        return new RequestMessage.EncodingMetadata(firstDocumentStartPosition);
    }
}

