/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.mongodb.internal.connection;

import com.grinderwolf.swm.internal.mongodb.MongoCompressor;
import com.grinderwolf.swm.internal.mongodb.MongoCredential;
import com.grinderwolf.swm.internal.mongodb.MongoDriverInformation;
import com.grinderwolf.swm.internal.mongodb.ServerAddress;
import com.grinderwolf.swm.internal.mongodb.connection.ClusterId;
import com.grinderwolf.swm.internal.mongodb.connection.ClusterSettings;
import com.grinderwolf.swm.internal.mongodb.connection.ConnectionPoolSettings;
import com.grinderwolf.swm.internal.mongodb.connection.ServerId;
import com.grinderwolf.swm.internal.mongodb.connection.ServerSettings;
import com.grinderwolf.swm.internal.mongodb.connection.StreamFactory;
import com.grinderwolf.swm.internal.mongodb.event.CommandListener;
import com.grinderwolf.swm.internal.mongodb.event.ServerListener;
import com.grinderwolf.swm.internal.mongodb.internal.connection.ClusterClock;
import com.grinderwolf.swm.internal.mongodb.internal.connection.ClusterableServer;
import com.grinderwolf.swm.internal.mongodb.internal.connection.ClusterableServerFactory;
import com.grinderwolf.swm.internal.mongodb.internal.connection.DefaultConnectionFactory;
import com.grinderwolf.swm.internal.mongodb.internal.connection.DefaultConnectionPool;
import com.grinderwolf.swm.internal.mongodb.internal.connection.DefaultServer;
import com.grinderwolf.swm.internal.mongodb.internal.connection.DefaultServerMonitorFactory;
import com.grinderwolf.swm.internal.mongodb.internal.connection.InternalStreamConnectionFactory;
import com.grinderwolf.swm.internal.mongodb.internal.connection.MongoCredentialWithCache;
import java.util.Collections;
import java.util.List;

public class DefaultClusterableServerFactory
implements ClusterableServerFactory {
    private final ClusterId clusterId;
    private final ClusterSettings clusterSettings;
    private final ServerSettings serverSettings;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final StreamFactory streamFactory;
    private final List<MongoCredentialWithCache> credentialList;
    private final StreamFactory heartbeatStreamFactory;
    private final CommandListener commandListener;
    private final String applicationName;
    private final MongoDriverInformation mongoDriverInformation;
    private final List<MongoCompressor> compressorList;

    public DefaultClusterableServerFactory(ClusterId clusterId, ClusterSettings clusterSettings, ServerSettings serverSettings, ConnectionPoolSettings connectionPoolSettings, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory, List<MongoCredential> credentialList, CommandListener commandListener, String applicationName, MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList) {
        this.clusterId = clusterId;
        this.clusterSettings = clusterSettings;
        this.serverSettings = serverSettings;
        this.connectionPoolSettings = connectionPoolSettings;
        this.streamFactory = streamFactory;
        this.credentialList = MongoCredentialWithCache.wrapCredentialList(credentialList);
        this.heartbeatStreamFactory = heartbeatStreamFactory;
        this.commandListener = commandListener;
        this.applicationName = applicationName;
        this.mongoDriverInformation = mongoDriverInformation;
        this.compressorList = compressorList;
    }

    @Override
    public ClusterableServer create(ServerAddress serverAddress, ServerListener serverListener, ClusterClock clusterClock) {
        DefaultConnectionPool connectionPool = new DefaultConnectionPool(new ServerId(this.clusterId, serverAddress), new InternalStreamConnectionFactory(this.streamFactory, this.credentialList, this.applicationName, this.mongoDriverInformation, this.compressorList, this.commandListener), this.connectionPoolSettings);
        connectionPool.start();
        DefaultServerMonitorFactory serverMonitorFactory = new DefaultServerMonitorFactory(new ServerId(this.clusterId, serverAddress), this.serverSettings, clusterClock, new InternalStreamConnectionFactory(this.heartbeatStreamFactory, Collections.<MongoCredentialWithCache>emptyList(), this.applicationName, this.mongoDriverInformation, Collections.<MongoCompressor>emptyList(), null), connectionPool);
        return new DefaultServer(new ServerId(this.clusterId, serverAddress), this.clusterSettings.getMode(), connectionPool, new DefaultConnectionFactory(), serverMonitorFactory, serverListener, this.commandListener, clusterClock);
    }

    @Override
    public ServerSettings getSettings() {
        return this.serverSettings;
    }
}

