/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.mongodb.event;

import com.grinderwolf.swm.internal.mongodb.annotations.Immutable;
import com.grinderwolf.swm.internal.mongodb.assertions.Assertions;
import com.grinderwolf.swm.internal.mongodb.diagnostics.logging.Logger;
import com.grinderwolf.swm.internal.mongodb.diagnostics.logging.Loggers;
import com.grinderwolf.swm.internal.mongodb.event.ClusterClosedEvent;
import com.grinderwolf.swm.internal.mongodb.event.ClusterDescriptionChangedEvent;
import com.grinderwolf.swm.internal.mongodb.event.ClusterListener;
import com.grinderwolf.swm.internal.mongodb.event.ClusterOpeningEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Deprecated
@Immutable
public final class ClusterEventMulticaster
implements ClusterListener {
    private static final Logger LOGGER = Loggers.getLogger("cluster.event");
    private final List<ClusterListener> clusterListeners;

    public ClusterEventMulticaster(List<ClusterListener> clusterListeners) {
        Assertions.notNull("clusterListeners", clusterListeners);
        Assertions.isTrue("All ClusterListener instances are non-null", !clusterListeners.contains(null));
        this.clusterListeners = new ArrayList<ClusterListener>(clusterListeners);
    }

    public List<ClusterListener> getClusterListeners() {
        return Collections.unmodifiableList(this.clusterListeners);
    }

    @Override
    public void clusterOpening(ClusterOpeningEvent event) {
        for (ClusterListener cur : this.clusterListeners) {
            try {
                cur.clusterOpening(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising cluster opening event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void clusterClosed(ClusterClosedEvent event) {
        for (ClusterListener cur : this.clusterListeners) {
            try {
                cur.clusterClosed(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising cluster closed event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void clusterDescriptionChanged(ClusterDescriptionChangedEvent event) {
        for (ClusterListener cur : this.clusterListeners) {
            try {
                cur.clusterDescriptionChanged(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising cluster description changed event to listener %s", cur), e);
            }
        }
    }
}

