/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.mongodb.client.model.geojson.codecs;

import com.grinderwolf.swm.internal.bson.BsonReader;
import com.grinderwolf.swm.internal.bson.BsonWriter;
import com.grinderwolf.swm.internal.bson.codecs.Codec;
import com.grinderwolf.swm.internal.bson.codecs.DecoderContext;
import com.grinderwolf.swm.internal.bson.codecs.EncoderContext;
import com.grinderwolf.swm.internal.bson.codecs.configuration.CodecConfigurationException;
import com.grinderwolf.swm.internal.mongodb.client.model.geojson.CoordinateReferenceSystem;
import com.grinderwolf.swm.internal.mongodb.client.model.geojson.NamedCoordinateReferenceSystem;
import com.grinderwolf.swm.internal.mongodb.client.model.geojson.codecs.GeometryDecoderHelper;

public class NamedCoordinateReferenceSystemCodec
implements Codec<NamedCoordinateReferenceSystem> {
    @Override
    public void encode(BsonWriter writer, NamedCoordinateReferenceSystem value, EncoderContext encoderContext) {
        writer.writeStartDocument();
        writer.writeString("type", value.getType().getTypeName());
        writer.writeStartDocument("properties");
        writer.writeString("name", value.getName());
        writer.writeEndDocument();
        writer.writeEndDocument();
    }

    @Override
    public Class<NamedCoordinateReferenceSystem> getEncoderClass() {
        return NamedCoordinateReferenceSystem.class;
    }

    @Override
    public NamedCoordinateReferenceSystem decode(BsonReader reader, DecoderContext decoderContext) {
        CoordinateReferenceSystem crs = GeometryDecoderHelper.decodeCoordinateReferenceSystem(reader);
        if (crs == null || !(crs instanceof NamedCoordinateReferenceSystem)) {
            throw new CodecConfigurationException("Invalid NamedCoordinateReferenceSystem.");
        }
        return (NamedCoordinateReferenceSystem)crs;
    }
}

