/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.mongodb.client.model;

import com.grinderwolf.swm.internal.bson.conversions.Bson;
import com.grinderwolf.swm.internal.mongodb.assertions.Assertions;

public final class BsonField {
    private final String name;
    private final Bson value;

    public BsonField(String name, Bson value) {
        this.name = Assertions.notNull("name", name);
        this.value = Assertions.notNull("value", value);
    }

    public String getName() {
        return this.name;
    }

    public Bson getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BsonField bsonField = (BsonField)o;
        if (!this.name.equals(bsonField.name)) {
            return false;
        }
        return this.value.equals(bsonField.value);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        return "BsonField{name='" + this.name + '\'' + ", value=" + this.value + '}';
    }
}

