/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.mongodb.client.internal;

import com.grinderwolf.swm.internal.bson.RawBsonDocument;
import com.grinderwolf.swm.internal.bson.conversions.Bson;
import com.grinderwolf.swm.internal.mongodb.MongoClientException;
import com.grinderwolf.swm.internal.mongodb.MongoException;
import com.grinderwolf.swm.internal.mongodb.MongoTimeoutException;
import com.grinderwolf.swm.internal.mongodb.ReadConcern;
import com.grinderwolf.swm.internal.mongodb.ReadPreference;
import com.grinderwolf.swm.internal.mongodb.assertions.Assertions;
import com.grinderwolf.swm.internal.mongodb.client.MongoClient;
import com.grinderwolf.swm.internal.mongodb.client.MongoClients;
import com.grinderwolf.swm.internal.mongodb.internal.capi.MongoCryptHelper;
import java.io.Closeable;
import java.util.Map;

class CommandMarker
implements Closeable {
    private final MongoClient client;
    private final ProcessBuilder processBuilder;

    CommandMarker(boolean isBypassAutoEncryption, Map<String, Object> options) {
        if (isBypassAutoEncryption) {
            this.processBuilder = null;
            this.client = null;
            return;
        }
        if (!options.containsKey("mongocryptdBypassSpawn") || !((Boolean)options.get("mongocryptdBypassSpawn")).booleanValue()) {
            this.processBuilder = MongoCryptHelper.createProcessBuilder(options);
            MongoCryptHelper.startProcess(this.processBuilder);
        } else {
            this.processBuilder = null;
        }
        this.client = MongoClients.create(MongoCryptHelper.createMongocryptdClientSettings((String)options.get("mongocryptdURI")));
    }

    RawBsonDocument mark(String databaseName, RawBsonDocument command) {
        Assertions.notNull("client", this.client);
        try {
            try {
                return this.executeCommand(databaseName, command);
            }
            catch (MongoTimeoutException e) {
                if (this.processBuilder == null) {
                    throw e;
                }
                MongoCryptHelper.startProcess(this.processBuilder);
                return this.executeCommand(databaseName, command);
            }
        }
        catch (MongoException e) {
            throw this.wrapInClientException(e);
        }
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    private RawBsonDocument executeCommand(String databaseName, RawBsonDocument markableCommand) {
        return this.client.getDatabase(databaseName).withReadConcern(ReadConcern.DEFAULT).withReadPreference(ReadPreference.primary()).runCommand((Bson)markableCommand, RawBsonDocument.class);
    }

    private MongoClientException wrapInClientException(MongoException e) {
        return new MongoClientException("Exception in encryption library: " + e.getMessage(), e);
    }
}

