/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.mongodb.client.internal;

import com.grinderwolf.swm.internal.bson.BsonBinary;
import com.grinderwolf.swm.internal.bson.BsonDocument;
import com.grinderwolf.swm.internal.bson.BsonValue;
import com.grinderwolf.swm.internal.mongodb.ClientEncryptionSettings;
import com.grinderwolf.swm.internal.mongodb.MongoNamespace;
import com.grinderwolf.swm.internal.mongodb.WriteConcern;
import com.grinderwolf.swm.internal.mongodb.client.MongoClient;
import com.grinderwolf.swm.internal.mongodb.client.MongoClients;
import com.grinderwolf.swm.internal.mongodb.client.internal.Crypt;
import com.grinderwolf.swm.internal.mongodb.client.internal.Crypts;
import com.grinderwolf.swm.internal.mongodb.client.internal.SimpleMongoClients;
import com.grinderwolf.swm.internal.mongodb.client.model.vault.DataKeyOptions;
import com.grinderwolf.swm.internal.mongodb.client.model.vault.EncryptOptions;
import com.grinderwolf.swm.internal.mongodb.client.vault.ClientEncryption;
import java.io.Closeable;

public class ClientEncryptionImpl
implements ClientEncryption,
Closeable {
    private final Crypt crypt;
    private final ClientEncryptionSettings options;
    private final MongoClient keyVaultClient;

    public ClientEncryptionImpl(ClientEncryptionSettings options) {
        this.keyVaultClient = MongoClients.create(options.getKeyVaultMongoClientSettings());
        this.crypt = Crypts.create(SimpleMongoClients.create(this.keyVaultClient), options);
        this.options = options;
    }

    @Override
    public BsonBinary createDataKey(String kmsProvider) {
        return this.createDataKey(kmsProvider, new DataKeyOptions());
    }

    @Override
    public BsonBinary createDataKey(String kmsProvider, DataKeyOptions dataKeyOptions) {
        BsonDocument dataKeyDocument = this.crypt.createDataKey(kmsProvider, dataKeyOptions);
        MongoNamespace namespace = new MongoNamespace(this.options.getKeyVaultNamespace());
        this.keyVaultClient.getDatabase(namespace.getDatabaseName()).getCollection(namespace.getCollectionName(), BsonDocument.class).withWriteConcern(WriteConcern.MAJORITY).insertOne(dataKeyDocument);
        return dataKeyDocument.getBinary("_id");
    }

    @Override
    public BsonBinary encrypt(BsonValue value, EncryptOptions options) {
        return this.crypt.encryptExplicitly(value, options);
    }

    @Override
    public BsonValue decrypt(BsonBinary value) {
        return this.crypt.decryptExplicitly(value);
    }

    @Override
    public void close() {
        this.crypt.close();
        this.keyVaultClient.close();
    }
}

