/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.mongodb;

import com.grinderwolf.swm.internal.bson.BSONObject;
import com.grinderwolf.swm.internal.bson.io.OutputBuffer;
import com.grinderwolf.swm.internal.mongodb.DBEncoder;
import com.grinderwolf.swm.internal.mongodb.LazyDBObject;
import com.grinderwolf.swm.internal.mongodb.MongoException;
import java.io.IOException;

public class LazyDBEncoder
implements DBEncoder {
    @Override
    public int writeObject(OutputBuffer outputBuffer, BSONObject document) {
        if (!(document instanceof LazyDBObject)) {
            throw new IllegalArgumentException("LazyDBEncoder can only encode BSONObject instances of type LazyDBObject");
        }
        LazyDBObject lazyDBObject = (LazyDBObject)document;
        try {
            return lazyDBObject.pipe(outputBuffer);
        }
        catch (IOException e) {
            throw new MongoException("Exception serializing a LazyDBObject", e);
        }
    }
}

