/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.mongodb;

import com.grinderwolf.swm.internal.bson.BSONObject;
import com.grinderwolf.swm.internal.bson.BasicBSONEncoder;
import com.grinderwolf.swm.internal.bson.io.OutputBuffer;
import com.grinderwolf.swm.internal.mongodb.BasicDBObject;
import com.grinderwolf.swm.internal.mongodb.DBEncoder;
import com.grinderwolf.swm.internal.mongodb.DBEncoderFactory;
import com.grinderwolf.swm.internal.mongodb.DBRef;

public class DefaultDBEncoder
extends BasicBSONEncoder
implements DBEncoder {
    public static final DBEncoderFactory FACTORY = new DBEncoderFactory(){

        @Override
        public DBEncoder create() {
            return new DefaultDBEncoder();
        }
    };

    @Override
    public int writeObject(OutputBuffer outputBuffer, BSONObject document) {
        this.set(outputBuffer);
        int x = this.putObject(document);
        this.done();
        return x;
    }

    @Override
    protected boolean putSpecial(String name, Object value) {
        if (value instanceof DBRef) {
            this.putDBRef(name, (DBRef)value);
            return true;
        }
        return false;
    }

    protected void putDBRef(String name, DBRef ref) {
        BasicDBObject dbRefDocument = new BasicDBObject("$ref", ref.getCollectionName()).append("$id", ref.getId());
        if (ref.getDatabaseName() != null) {
            dbRefDocument.put("$db", ref.getDatabaseName());
        }
        this.putObject(name, dbRefDocument);
    }

    public String toString() {
        return String.format("DBEncoder{class=%s}", this.getClass().getName());
    }
}

