/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.mongodb;

import com.grinderwolf.swm.internal.bson.BsonReader;
import com.grinderwolf.swm.internal.bson.BsonWriter;
import com.grinderwolf.swm.internal.bson.codecs.Codec;
import com.grinderwolf.swm.internal.bson.codecs.Decoder;
import com.grinderwolf.swm.internal.bson.codecs.DecoderContext;
import com.grinderwolf.swm.internal.bson.codecs.Encoder;
import com.grinderwolf.swm.internal.bson.codecs.EncoderContext;
import com.grinderwolf.swm.internal.mongodb.DBObject;

class CompoundDBObjectCodec
implements Codec<DBObject> {
    private final Encoder<DBObject> encoder;
    private final Decoder<DBObject> decoder;

    CompoundDBObjectCodec(Encoder<DBObject> encoder, Decoder<DBObject> decoder) {
        this.encoder = encoder;
        this.decoder = decoder;
    }

    CompoundDBObjectCodec(Codec<DBObject> codec) {
        this(codec, codec);
    }

    @Override
    public DBObject decode(BsonReader reader, DecoderContext decoderContext) {
        return this.decoder.decode(reader, decoderContext);
    }

    @Override
    public void encode(BsonWriter writer, DBObject value, EncoderContext encoderContext) {
        this.encoder.encode(writer, value, encoderContext);
    }

    @Override
    public Class<DBObject> getEncoderClass() {
        return DBObject.class;
    }

    public Encoder<DBObject> getEncoder() {
        return this.encoder;
    }

    public Decoder<DBObject> getDecoder() {
        return this.decoder;
    }
}

