/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.mongodb;

import com.grinderwolf.swm.internal.bson.BsonDocument;
import com.grinderwolf.swm.internal.bson.BsonDocumentReader;
import com.grinderwolf.swm.internal.bson.codecs.Decoder;
import com.grinderwolf.swm.internal.bson.codecs.DecoderContext;
import com.grinderwolf.swm.internal.mongodb.AcknowledgedBulkWriteResult;
import com.grinderwolf.swm.internal.mongodb.BulkWriteException;
import com.grinderwolf.swm.internal.mongodb.BulkWriteUpsert;
import com.grinderwolf.swm.internal.mongodb.DBObject;
import com.grinderwolf.swm.internal.mongodb.DBObjects;
import com.grinderwolf.swm.internal.mongodb.MongoBulkWriteException;
import com.grinderwolf.swm.internal.mongodb.UnacknowledgedBulkWriteResult;
import com.grinderwolf.swm.internal.mongodb.bulk.BulkWriteError;
import com.grinderwolf.swm.internal.mongodb.bulk.BulkWriteResult;
import com.grinderwolf.swm.internal.mongodb.bulk.WriteConcernError;
import java.util.ArrayList;
import java.util.List;

final class BulkWriteHelper {
    static com.grinderwolf.swm.internal.mongodb.BulkWriteResult translateBulkWriteResult(BulkWriteResult bulkWriteResult, Decoder<DBObject> decoder) {
        if (bulkWriteResult.wasAcknowledged()) {
            return new AcknowledgedBulkWriteResult(bulkWriteResult.getInsertedCount(), bulkWriteResult.getMatchedCount(), bulkWriteResult.getDeletedCount(), bulkWriteResult.getModifiedCount(), BulkWriteHelper.translateBulkWriteUpserts(bulkWriteResult.getUpserts(), decoder));
        }
        return new UnacknowledgedBulkWriteResult();
    }

    static List<BulkWriteUpsert> translateBulkWriteUpserts(List<com.grinderwolf.swm.internal.mongodb.bulk.BulkWriteUpsert> upserts, Decoder<DBObject> decoder) {
        ArrayList<BulkWriteUpsert> retVal = new ArrayList<BulkWriteUpsert>(upserts.size());
        for (com.grinderwolf.swm.internal.mongodb.bulk.BulkWriteUpsert cur : upserts) {
            retVal.add(new BulkWriteUpsert(cur.getIndex(), BulkWriteHelper.getUpsertedId(cur, decoder)));
        }
        return retVal;
    }

    private static Object getUpsertedId(com.grinderwolf.swm.internal.mongodb.bulk.BulkWriteUpsert cur, Decoder<DBObject> decoder) {
        return decoder.decode(new BsonDocumentReader(new BsonDocument("_id", cur.getId())), DecoderContext.builder().build()).get("_id");
    }

    static BulkWriteException translateBulkWriteException(MongoBulkWriteException e, Decoder<DBObject> decoder) {
        return new BulkWriteException(BulkWriteHelper.translateBulkWriteResult(e.getWriteResult(), decoder), BulkWriteHelper.translateWriteErrors(e.getWriteErrors()), BulkWriteHelper.translateWriteConcernError(e.getWriteConcernError()), e.getServerAddress());
    }

    static com.grinderwolf.swm.internal.mongodb.WriteConcernError translateWriteConcernError(WriteConcernError writeConcernError) {
        return writeConcernError == null ? null : new com.grinderwolf.swm.internal.mongodb.WriteConcernError(writeConcernError.getCode(), writeConcernError.getMessage(), DBObjects.toDBObject(writeConcernError.getDetails()));
    }

    static List<com.grinderwolf.swm.internal.mongodb.BulkWriteError> translateWriteErrors(List<BulkWriteError> errors) {
        ArrayList<com.grinderwolf.swm.internal.mongodb.BulkWriteError> retVal = new ArrayList<com.grinderwolf.swm.internal.mongodb.BulkWriteError>(errors.size());
        for (BulkWriteError cur : errors) {
            retVal.add(new com.grinderwolf.swm.internal.mongodb.BulkWriteError(cur.getCode(), cur.getMessage(), DBObjects.toDBObject(cur.getDetails()), cur.getIndex()));
        }
        return retVal;
    }

    private BulkWriteHelper() {
    }
}

