/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.support.caching;

import com.grinderwolf.swm.internal.lettuce.core.api.StatefulRedisConnection;
import com.grinderwolf.swm.internal.lettuce.core.codec.RedisCodec;
import com.grinderwolf.swm.internal.lettuce.core.support.caching.RedisCache;
import java.util.List;
import java.util.function.Consumer;

class DefaultRedisCache<K, V>
implements RedisCache<K, V> {
    private final StatefulRedisConnection<K, V> connection;
    private final RedisCodec<K, V> codec;

    public DefaultRedisCache(StatefulRedisConnection<K, V> connection, RedisCodec<K, V> codec) {
        this.connection = connection;
        this.codec = codec;
    }

    @Override
    public V get(K key) {
        return this.connection.sync().get(key);
    }

    @Override
    public void put(K key, V value) {
        this.connection.sync().set(key, value);
    }

    @Override
    public void addInvalidationListener(Consumer<? super K> listener) {
        this.connection.addListener(message -> {
            if (message.getType().equals("invalidate")) {
                List<Object> content = message.getContent(this.codec::decodeKey);
                List keys = (List)content.get(1);
                keys.forEach(listener);
            }
        });
    }

    @Override
    public void close() {
        this.connection.close();
    }
}

