/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.support;

import com.grinderwolf.swm.internal.lettuce.core.support.BasePoolConfig;

public class BoundedPoolConfig
extends BasePoolConfig {
    public static final int DEFAULT_MAX_TOTAL = 8;
    public static final int DEFAULT_MAX_IDLE = 8;
    public static final int DEFAULT_MIN_IDLE = 0;
    private final int maxTotal;
    private final int maxIdle;
    private final int minIdle;

    protected BoundedPoolConfig(boolean testOnCreate, boolean testOnAcquire, boolean testOnRelease, int maxTotal, int maxIdle, int minIdle) {
        super(testOnCreate, testOnAcquire, testOnRelease);
        this.maxTotal = maxTotal;
        this.maxIdle = maxIdle;
        this.minIdle = minIdle;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BoundedPoolConfig create() {
        return BoundedPoolConfig.builder().build();
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public static class Builder
    extends BasePoolConfig.Builder {
        private int maxTotal = 8;
        private int maxIdle = 8;
        private int minIdle = 0;

        protected Builder() {
        }

        @Override
        public Builder testOnCreate() {
            super.testOnCreate();
            return this;
        }

        @Override
        public Builder testOnCreate(boolean testOnCreate) {
            super.testOnCreate(testOnCreate);
            return this;
        }

        @Override
        public Builder testOnAcquire() {
            super.testOnAcquire();
            return this;
        }

        @Override
        public Builder testOnAcquire(boolean testOnAcquire) {
            super.testOnAcquire(testOnAcquire);
            return this;
        }

        @Override
        public Builder testOnRelease() {
            super.testOnRelease();
            return this;
        }

        @Override
        public Builder testOnRelease(boolean testOnRelease) {
            super.testOnRelease(testOnRelease);
            return this;
        }

        public Builder maxTotal(int maxTotal) {
            this.maxTotal = maxTotal;
            return this;
        }

        public Builder maxIdle(int maxIdle) {
            this.maxIdle = maxIdle;
            return this;
        }

        public Builder minIdle(int minIdle) {
            this.minIdle = minIdle;
            return this;
        }

        public BoundedPoolConfig build() {
            return new BoundedPoolConfig(this.testOnCreate, this.testOnAcquire, this.testOnRelease, this.maxTotal, this.maxIdle, this.minIdle);
        }
    }
}

