/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.resource;

import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceAssert;
import com.grinderwolf.swm.internal.lettuce.core.resource.EpollProvider;
import com.grinderwolf.swm.internal.lettuce.core.resource.EventLoopResources;
import com.grinderwolf.swm.internal.lettuce.core.resource.IOUringProvider;
import com.grinderwolf.swm.internal.lettuce.core.resource.KqueueProvider;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;

public class Transports {
    public static Class<? extends EventLoopGroup> eventLoopGroupClass() {
        if (NativeTransports.isAvailable()) {
            return NativeTransports.eventLoopGroupClass();
        }
        return NioEventLoopGroup.class;
    }

    public static Class<? extends Channel> socketChannelClass() {
        if (NativeTransports.isAvailable()) {
            return NativeTransports.socketChannelClass();
        }
        return NioSocketChannel.class;
    }

    public static Class<? extends DatagramChannel> datagramChannelClass() {
        if (NativeTransports.isAvailable()) {
            return NativeTransports.datagramChannelClass();
        }
        return NioDatagramChannel.class;
    }

    public static class NativeTransports {
        static EventLoopResources RESOURCES = KqueueProvider.isAvailable() ? KqueueProvider.getResources() : (IOUringProvider.isAvailable() ? IOUringProvider.getResources() : EpollProvider.getResources());

        static boolean isAvailable() {
            return EpollProvider.isAvailable() || KqueueProvider.isAvailable() || IOUringProvider.isAvailable();
        }

        public static boolean isDomainSocketSupported() {
            return EpollProvider.isAvailable() || KqueueProvider.isAvailable();
        }

        static Class<? extends Channel> socketChannelClass() {
            return RESOURCES.socketChannelClass();
        }

        static Class<? extends DatagramChannel> datagramChannelClass() {
            return RESOURCES.datagramChannelClass();
        }

        public static Class<? extends Channel> domainSocketChannelClass() {
            NativeTransports.assertDomainSocketAvailable();
            return RESOURCES.domainSocketChannelClass();
        }

        public static Class<? extends EventLoopGroup> eventLoopGroupClass() {
            return RESOURCES.eventLoopGroupClass();
        }

        public static void assertDomainSocketAvailable() {
            LettuceAssert.assertState(NativeTransports.isDomainSocketSupported(), "A unix domain socket connection requires epoll or kqueue and neither is available");
        }
    }
}

