/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.resource;

import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceAssert;
import com.grinderwolf.swm.internal.lettuce.core.resource.DefaultThreadFactoryProvider;
import com.grinderwolf.swm.internal.lettuce.core.resource.EpollProvider;
import com.grinderwolf.swm.internal.lettuce.core.resource.EventLoopGroupProvider;
import com.grinderwolf.swm.internal.lettuce.core.resource.EventLoopResources;
import com.grinderwolf.swm.internal.lettuce.core.resource.IOUringProvider;
import com.grinderwolf.swm.internal.lettuce.core.resource.KqueueProvider;
import com.grinderwolf.swm.internal.lettuce.core.resource.PromiseAdapter;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import io.netty.util.concurrent.SucceededFuture;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DefaultEventLoopGroupProvider
implements EventLoopGroupProvider {
    protected static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultEventLoopGroupProvider.class);
    private final Lock lock = new ReentrantLock();
    private final Map<Class<? extends EventExecutorGroup>, EventExecutorGroup> eventLoopGroups = new ConcurrentHashMap<Class<? extends EventExecutorGroup>, EventExecutorGroup>(2);
    private final Map<ExecutorService, Long> refCounter = new ConcurrentHashMap<ExecutorService, Long>(2);
    private final int numberOfThreads;
    private final com.grinderwolf.swm.internal.lettuce.core.resource.ThreadFactoryProvider threadFactoryProvider;
    private volatile boolean shutdownCalled = false;

    public DefaultEventLoopGroupProvider(int numberOfThreads) {
        this(numberOfThreads, DefaultThreadFactoryProvider.INSTANCE);
    }

    public DefaultEventLoopGroupProvider(int numberOfThreads, ThreadFactoryProvider threadFactoryProvider) {
        LettuceAssert.isTrue(numberOfThreads > 0, "Number of threads must be greater than zero");
        LettuceAssert.notNull((Object)threadFactoryProvider, "ThreadFactoryProvider must not be null");
        this.numberOfThreads = numberOfThreads;
        this.threadFactoryProvider = threadFactoryProvider;
    }

    public DefaultEventLoopGroupProvider(int numberOfThreads, com.grinderwolf.swm.internal.lettuce.core.resource.ThreadFactoryProvider threadFactoryProvider) {
        LettuceAssert.isTrue(numberOfThreads > 0, "Number of threads must be greater than zero");
        LettuceAssert.notNull((Object)threadFactoryProvider, "ThreadFactoryProvider must not be null");
        this.numberOfThreads = numberOfThreads;
        this.threadFactoryProvider = threadFactoryProvider;
    }

    @Override
    public <T extends EventLoopGroup> T allocate(Class<T> type) {
        this.lock.lock();
        try {
            logger.debug("Allocating executor {}", (Object)type.getName());
            EventLoopGroup eventLoopGroup = (EventLoopGroup)this.addReference(this.getOrCreate(type));
            return (T)eventLoopGroup;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ExecutorService> T addReference(T reference) {
        this.lock.lock();
        try {
            long counter = 0L;
            if (this.refCounter.containsKey(reference)) {
                counter = this.refCounter.get(reference);
            }
            logger.debug("Adding reference to {}, existing ref count {}", (Object)reference, (Object)counter);
            this.refCounter.put(reference, ++counter);
        }
        finally {
            this.lock.unlock();
        }
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ExecutorService> T release(T reference) {
        this.lock.lock();
        try {
            long counter = 0L;
            if (this.refCounter.containsKey(reference)) {
                counter = this.refCounter.get(reference);
            }
            if (counter < 1L) {
                logger.debug("Attempting to release {} but ref count is {}", (Object)reference, (Object)counter);
            }
            if (--counter == 0L) {
                this.refCounter.remove(reference);
            } else {
                this.refCounter.put(reference, counter);
            }
        }
        finally {
            this.lock.unlock();
        }
        return reference;
    }

    private <T extends EventLoopGroup> T getOrCreate(Class<T> type) {
        if (this.shutdownCalled) {
            throw new IllegalStateException("Provider is shut down and can not longer provide resources");
        }
        if (!this.eventLoopGroups.containsKey(type)) {
            this.eventLoopGroups.put(type, this.doCreateEventLoopGroup(type, this.numberOfThreads, this.threadFactoryProvider));
        }
        return (T)((EventLoopGroup)this.eventLoopGroups.get(type));
    }

    protected <T extends EventLoopGroup> EventExecutorGroup doCreateEventLoopGroup(Class<T> type, int numberOfThreads, com.grinderwolf.swm.internal.lettuce.core.resource.ThreadFactoryProvider threadFactoryProvider) {
        return DefaultEventLoopGroupProvider.createEventLoopGroup(type, numberOfThreads, threadFactoryProvider);
    }

    public static <T extends EventExecutorGroup> EventExecutorGroup createEventLoopGroup(Class<T> type, int numberOfThreads) {
        return DefaultEventLoopGroupProvider.createEventLoopGroup(type, numberOfThreads, DefaultThreadFactoryProvider.INSTANCE);
    }

    static <T extends EventExecutorGroup> EventExecutorGroup createEventLoopGroup(Class<T> type, int numberOfThreads, com.grinderwolf.swm.internal.lettuce.core.resource.ThreadFactoryProvider factoryProvider) {
        EventLoopResources resources;
        logger.debug("Creating executor {}", (Object)type.getName());
        if (DefaultEventExecutorGroup.class.equals(type)) {
            return new DefaultEventExecutorGroup(numberOfThreads, factoryProvider.getThreadFactory("lettuce-eventExecutorLoop"));
        }
        if (NioEventLoopGroup.class.equals(type)) {
            return new NioEventLoopGroup(numberOfThreads, factoryProvider.getThreadFactory("lettuce-nioEventLoop"));
        }
        if (EpollProvider.isAvailable() && (resources = EpollProvider.getResources()).matches(type)) {
            return resources.newEventLoopGroup(numberOfThreads, factoryProvider.getThreadFactory("lettuce-epollEventLoop"));
        }
        if (KqueueProvider.isAvailable() && (resources = KqueueProvider.getResources()).matches(type)) {
            return resources.newEventLoopGroup(numberOfThreads, factoryProvider.getThreadFactory("lettuce-kqueueEventLoop"));
        }
        if (IOUringProvider.isAvailable() && (resources = IOUringProvider.getResources()).matches(type)) {
            return resources.newEventLoopGroup(numberOfThreads, factoryProvider.getThreadFactory("lettuce-io_uringEventLoop"));
        }
        throw new IllegalArgumentException(String.format("Type %s not supported", type.getName()));
    }

    public Promise<Boolean> release(EventExecutorGroup eventLoopGroup, long quietPeriod, long timeout, TimeUnit unit) {
        return PromiseAdapter.toBooleanPromise(this.doRelease(eventLoopGroup, quietPeriod, timeout, unit));
    }

    private Future<?> doRelease(EventExecutorGroup eventLoopGroup, long quietPeriod, long timeout, TimeUnit unit) {
        logger.debug("Release executor {}", (Object)eventLoopGroup);
        Class<?> key = this.getKey(this.release(eventLoopGroup));
        if (key == null && eventLoopGroup.isShuttingDown() || this.refCounter.containsKey(eventLoopGroup)) {
            return new SucceededFuture<Boolean>(ImmediateEventExecutor.INSTANCE, true);
        }
        if (key != null) {
            this.eventLoopGroups.remove(key);
        }
        return eventLoopGroup.shutdownGracefully(quietPeriod, timeout, unit);
    }

    private Class<?> getKey(EventExecutorGroup eventLoopGroup) {
        Class key = null;
        HashMap<Class<? extends EventExecutorGroup>, EventExecutorGroup> copy = new HashMap<Class<? extends EventExecutorGroup>, EventExecutorGroup>(this.eventLoopGroups);
        for (Map.Entry entry : copy.entrySet()) {
            if (entry.getValue() != eventLoopGroup) continue;
            key = (Class)entry.getKey();
            break;
        }
        return key;
    }

    @Override
    public int threadPoolSize() {
        return this.numberOfThreads;
    }

    @Override
    public Future<Boolean> shutdown(long quietPeriod, long timeout, TimeUnit timeUnit) {
        logger.debug("Initiate shutdown ({}, {}, {})", new Object[]{quietPeriod, timeout, timeUnit});
        this.shutdownCalled = true;
        HashMap<Class<? extends EventExecutorGroup>, EventExecutorGroup> copy = new HashMap<Class<? extends EventExecutorGroup>, EventExecutorGroup>(this.eventLoopGroups);
        DefaultPromise<Void> overall = new DefaultPromise<Void>(ImmediateEventExecutor.INSTANCE);
        PromiseCombiner combiner = new PromiseCombiner(ImmediateEventExecutor.INSTANCE);
        for (EventExecutorGroup executorGroup : copy.values()) {
            combiner.add(this.doRelease(executorGroup, quietPeriod, timeout, timeUnit));
        }
        combiner.finish(overall);
        return PromiseAdapter.toBooleanPromise(overall);
    }

    public static interface ThreadFactoryProvider
    extends com.grinderwolf.swm.internal.lettuce.core.resource.ThreadFactoryProvider {
        @Override
        public ThreadFactory getThreadFactory(String var1);
    }
}

