/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.pubsub;

import com.grinderwolf.swm.internal.lettuce.core.codec.RedisCodec;
import com.grinderwolf.swm.internal.lettuce.core.output.CommandOutput;
import com.grinderwolf.swm.internal.lettuce.core.pubsub.PubSubMessage;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;

public class PubSubOutput<K, V>
extends CommandOutput<K, V, V>
implements PubSubMessage<K, V> {
    private Type type;
    private K channel;
    private K pattern;
    private long count;
    private boolean completed;

    public PubSubOutput(RedisCodec<K, V> codec) {
        super(codec, null);
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public K channel() {
        return this.channel;
    }

    @Override
    public K pattern() {
        return this.pattern;
    }

    @Override
    public long count() {
        return this.count;
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (bytes == null) {
            return;
        }
        if (this.type == null) {
            this.type = Type.valueOf(this.decodeAscii(bytes));
            return;
        }
        this.handleOutput(bytes);
    }

    private void handleOutput(ByteBuffer bytes) {
        switch (this.type) {
            case pmessage: {
                if (this.pattern == null) {
                    this.pattern = this.codec.decodeKey(bytes);
                    break;
                }
            }
            case message: {
                if (this.channel == null) {
                    this.channel = this.codec.decodeKey(bytes);
                    break;
                }
                this.output = this.codec.decodeValue(bytes);
                this.completed = true;
                break;
            }
            case psubscribe: 
            case punsubscribe: {
                this.pattern = this.codec.decodeKey(bytes);
                break;
            }
            case subscribe: 
            case unsubscribe: {
                this.channel = this.codec.decodeKey(bytes);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operation " + (Object)((Object)this.type) + " not supported");
            }
        }
    }

    @Override
    public void set(long integer) {
        this.count = integer;
        this.completed = true;
    }

    boolean isCompleted() {
        return this.completed;
    }

    @Override
    public V body() {
        return (V)this.output;
    }

    public static enum Type {
        message,
        pmessage,
        psubscribe,
        punsubscribe,
        subscribe,
        unsubscribe;

        private static final Set<String> names;

        public static boolean isPubSubType(String name) {
            return names.contains(name);
        }

        static {
            names = new HashSet<String>();
            for (Type value : Type.values()) {
                names.add(value.name());
            }
        }
    }
}

