/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.protocol;

import com.grinderwolf.swm.internal.lettuce.core.protocol.CommandWrapper;
import com.grinderwolf.swm.internal.lettuce.core.protocol.RedisCommand;
import com.grinderwolf.swm.internal.lettuce.core.tracing.TraceContext;
import com.grinderwolf.swm.internal.lettuce.core.tracing.TraceContextProvider;
import com.grinderwolf.swm.internal.lettuce.core.tracing.Tracer;
import io.netty.buffer.ByteBuf;

public class TracedCommand<K, V, T>
extends CommandWrapper<K, V, T>
implements TraceContextProvider {
    private final TraceContext traceContext;
    private Tracer.Span span;

    public TracedCommand(RedisCommand<K, V, T> command, TraceContext traceContext) {
        super(command);
        this.traceContext = traceContext;
    }

    @Override
    public TraceContext getTraceContext() {
        return this.traceContext;
    }

    public Tracer.Span getSpan() {
        return this.span;
    }

    public void setSpan(Tracer.Span span) {
        this.span = span;
    }

    @Override
    public void encode(ByteBuf buf) {
        if (this.span != null) {
            this.span.annotate("redis.encode.start");
        }
        super.encode(buf);
        if (this.span != null) {
            this.span.annotate("redis.encode.end");
        }
    }
}

