/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.protocol;

import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceAssert;
import com.grinderwolf.swm.internal.lettuce.core.protocol.DecodeBufferPolicy;
import io.netty.buffer.ByteBuf;

class RatioDecodeBufferPolicy
implements DecodeBufferPolicy {
    private final float discardReadBytesRatio;

    public RatioDecodeBufferPolicy(float bufferUsageRatio) {
        LettuceAssert.isTrue(bufferUsageRatio > 0.0f && bufferUsageRatio < 2.1474836E9f, "BufferUsageRatio must be greater than 0");
        this.discardReadBytesRatio = bufferUsageRatio / (bufferUsageRatio + 1.0f);
    }

    @Override
    public void afterPartialDecode(ByteBuf buffer) {
        this.discardReadBytesIfNecessary(buffer);
    }

    @Override
    public void afterDecoding(ByteBuf buffer) {
        this.discardReadBytesIfNecessary(buffer);
    }

    @Override
    public void afterCommandDecoded(ByteBuf buffer) {
        this.discardReadBytesIfNecessary(buffer);
    }

    private void discardReadBytesIfNecessary(ByteBuf buffer) {
        float usedRatio = (float)buffer.readerIndex() / (float)buffer.capacity();
        if (usedRatio >= this.discardReadBytesRatio) {
            buffer.discardReadBytes();
        }
    }
}

