/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.protocol;

import com.grinderwolf.swm.internal.lettuce.core.codec.StringCodec;
import com.grinderwolf.swm.internal.lettuce.core.output.CommandOutput;
import com.grinderwolf.swm.internal.lettuce.core.protocol.CommandArgs;
import com.grinderwolf.swm.internal.lettuce.core.protocol.ProtocolKeyword;
import com.grinderwolf.swm.internal.lettuce.core.protocol.RedisCommand;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

class PristineFallbackCommand
implements RedisCommand<String, String, List<String>> {
    private final CommandOutput<String, String, List<String>> output = new FallbackOutput();
    private volatile boolean complete;

    PristineFallbackCommand() {
    }

    @Override
    public CommandOutput<String, String, List<String>> getOutput() {
        return this.output;
    }

    @Override
    public void complete() {
        this.complete = true;
    }

    @Override
    public void cancel() {
        this.complete = true;
    }

    @Override
    public CommandArgs<String, String> getArgs() {
        return null;
    }

    @Override
    public boolean completeExceptionally(Throwable throwable) {
        return false;
    }

    @Override
    public ProtocolKeyword getType() {
        return null;
    }

    @Override
    public void encode(ByteBuf buf) {
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.complete;
    }

    @Override
    public void setOutput(CommandOutput<String, String, List<String>> output) {
    }

    static class FallbackOutput
    extends CommandOutput<String, String, List<String>> {
        FallbackOutput() {
            super(StringCodec.ASCII, new ArrayList());
        }

        @Override
        public void set(ByteBuffer bytes) {
            ((List)this.output).add(bytes != null ? (String)this.codec.decodeKey(bytes) : null);
        }

        @Override
        public void set(long integer) {
            ((List)this.output).add("" + integer);
        }
    }
}

