/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.protocol;

import com.grinderwolf.swm.internal.lettuce.core.protocol.DecodeBufferPolicy;
import com.grinderwolf.swm.internal.lettuce.core.protocol.RatioDecodeBufferPolicy;
import io.netty.buffer.ByteBuf;

public abstract class DecodeBufferPolicies {
    private static final DecodeBufferPolicy ALWAYS = new DecodeBufferPolicy(){

        @Override
        public void afterPartialDecode(ByteBuf buffer) {
            buffer.discardReadBytes();
        }

        @Override
        public void afterCommandDecoded(ByteBuf buffer) {
            buffer.discardReadBytes();
        }

        @Override
        public void afterDecoding(ByteBuf buffer) {
            buffer.discardReadBytes();
        }
    };
    private static final DecodeBufferPolicy ALWAYS_SOME = new DecodeBufferPolicy(){

        @Override
        public void afterPartialDecode(ByteBuf buffer) {
            buffer.discardSomeReadBytes();
        }

        @Override
        public void afterCommandDecoded(ByteBuf buffer) {
            buffer.discardSomeReadBytes();
        }

        @Override
        public void afterDecoding(ByteBuf buffer) {
            buffer.discardSomeReadBytes();
        }
    };

    private DecodeBufferPolicies() {
    }

    public static DecodeBufferPolicy ratio(float bufferUsageRatio) {
        return new RatioDecodeBufferPolicy(bufferUsageRatio);
    }

    public static DecodeBufferPolicy always() {
        return ALWAYS;
    }

    public static DecodeBufferPolicy alwaysSome() {
        return ALWAYS_SOME;
    }
}

