/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.output;

import com.grinderwolf.swm.internal.lettuce.core.codec.RedisCodec;
import com.grinderwolf.swm.internal.lettuce.core.output.CommandOutput;
import com.grinderwolf.swm.internal.lettuce.core.output.OutputFactory;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Set;

public class ValueSetOutput<K, V>
extends CommandOutput<K, V, Set<V>> {
    private boolean initialized;

    public ValueSetOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptySet());
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (bytes == null && !this.initialized) {
            return;
        }
        ((Set)this.output).add(bytes == null ? null : (Object)this.codec.decodeValue(bytes));
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newSet(count);
            this.initialized = true;
        }
    }
}

