/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.output;

import com.grinderwolf.swm.internal.lettuce.core.codec.RedisCodec;
import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceAssert;
import com.grinderwolf.swm.internal.lettuce.core.output.CommandOutput;
import com.grinderwolf.swm.internal.lettuce.core.output.ListSubscriber;
import com.grinderwolf.swm.internal.lettuce.core.output.OutputFactory;
import com.grinderwolf.swm.internal.lettuce.core.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ValueListOutput<K, V>
extends CommandOutput<K, V, List<V>>
implements StreamingOutput<V> {
    private boolean initialized;
    private StreamingOutput.Subscriber<V> subscriber;

    public ValueListOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
        this.setSubscriber(ListSubscriber.instance());
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (bytes == null && !this.initialized) {
            return;
        }
        this.subscriber.onNext((Collection)this.output, bytes == null ? null : (Object)this.codec.decodeValue(bytes));
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(count);
            this.initialized = true;
        }
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<V> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<V> getSubscriber() {
        return this.subscriber;
    }
}

