/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.output;

import com.grinderwolf.swm.internal.lettuce.core.ScoredValue;
import com.grinderwolf.swm.internal.lettuce.core.codec.RedisCodec;
import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceStrings;
import com.grinderwolf.swm.internal.lettuce.core.output.CommandOutput;
import com.grinderwolf.swm.internal.lettuce.core.output.ScoredValueStreamingChannel;
import java.nio.ByteBuffer;

public class ScoredValueStreamingOutput<K, V>
extends CommandOutput<K, V, Long> {
    private V value;
    private final ScoredValueStreamingChannel<V> channel;

    public ScoredValueStreamingOutput(RedisCodec<K, V> codec, ScoredValueStreamingChannel<V> channel) {
        super(codec, 0L);
        this.channel = channel;
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.value == null) {
            this.value = this.codec.decodeValue(bytes);
            return;
        }
        double score = LettuceStrings.toDouble(this.decodeAscii(bytes));
        this.set(score);
    }

    @Override
    public void set(double number) {
        this.channel.onValue(ScoredValue.just(number, this.value));
        this.value = null;
        this.output = (Long)this.output + 1L;
    }
}

