/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.output;

import com.grinderwolf.swm.internal.lettuce.core.ScoredValue;
import com.grinderwolf.swm.internal.lettuce.core.StreamScanCursor;
import com.grinderwolf.swm.internal.lettuce.core.codec.RedisCodec;
import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceStrings;
import com.grinderwolf.swm.internal.lettuce.core.output.ScanOutput;
import com.grinderwolf.swm.internal.lettuce.core.output.ScoredValueStreamingChannel;
import java.nio.ByteBuffer;

public class ScoredValueScanStreamingOutput<K, V>
extends ScanOutput<K, V, StreamScanCursor> {
    private final ScoredValueStreamingChannel<V> channel;
    private V value;

    public ScoredValueScanStreamingOutput(RedisCodec<K, V> codec, ScoredValueStreamingChannel<V> channel) {
        super(codec, new StreamScanCursor());
        this.channel = channel;
    }

    @Override
    protected void setOutput(ByteBuffer bytes) {
        if (this.value == null) {
            this.value = this.codec.decodeValue(bytes);
            return;
        }
        double score = LettuceStrings.toDouble(this.decodeAscii(bytes));
        this.set(score);
    }

    @Override
    public void set(double number) {
        if (this.value != null) {
            this.channel.onValue(ScoredValue.just(number, this.value));
        }
        this.value = null;
        ((StreamScanCursor)this.output).setCount(((StreamScanCursor)this.output).getCount() + 1L);
    }
}

