/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.output;

import com.grinderwolf.swm.internal.lettuce.core.ScoredValue;
import com.grinderwolf.swm.internal.lettuce.core.ScoredValueScanCursor;
import com.grinderwolf.swm.internal.lettuce.core.codec.RedisCodec;
import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceStrings;
import com.grinderwolf.swm.internal.lettuce.core.output.ScanOutput;
import java.nio.ByteBuffer;

public class ScoredValueScanOutput<K, V>
extends ScanOutput<K, V, ScoredValueScanCursor<V>> {
    private V value;

    public ScoredValueScanOutput(RedisCodec<K, V> codec) {
        super(codec, new ScoredValueScanCursor());
    }

    @Override
    protected void setOutput(ByteBuffer bytes) {
        if (this.value == null) {
            this.value = this.codec.decodeValue(bytes);
            return;
        }
        double score = LettuceStrings.toDouble(this.decodeAscii(bytes));
        this.set(score);
    }

    @Override
    public void set(double number) {
        if (this.value != null) {
            ((ScoredValueScanCursor)this.output).getValues().add(ScoredValue.just(number, this.value));
        }
        this.value = null;
    }
}

