/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.output;

import com.grinderwolf.swm.internal.lettuce.core.codec.RedisCodec;
import com.grinderwolf.swm.internal.lettuce.core.codec.StringCodec;
import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceAssert;
import com.grinderwolf.swm.internal.lettuce.core.models.stream.PendingMessage;
import com.grinderwolf.swm.internal.lettuce.core.output.CommandOutput;
import com.grinderwolf.swm.internal.lettuce.core.output.ListSubscriber;
import com.grinderwolf.swm.internal.lettuce.core.output.OutputFactory;
import com.grinderwolf.swm.internal.lettuce.core.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PendingMessageListOutput<K, V>
extends CommandOutput<K, V, List<PendingMessage>>
implements StreamingOutput<PendingMessage> {
    private boolean initialized;
    private StreamingOutput.Subscriber<PendingMessage> subscriber;
    private String messageId;
    private String consumer;
    private Long msSinceLastDelivery;

    public PendingMessageListOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
        this.setSubscriber((StreamingOutput.Subscriber<PendingMessage>)ListSubscriber.instance());
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.messageId == null) {
            this.messageId = this.decodeAscii(bytes);
            return;
        }
        if (this.consumer == null) {
            this.consumer = StringCodec.UTF8.decodeKey(bytes);
            return;
        }
        this.set(Long.parseLong(this.decodeAscii(bytes)));
    }

    @Override
    public void set(long integer) {
        if (this.msSinceLastDelivery == null) {
            this.msSinceLastDelivery = integer;
            return;
        }
        PendingMessage message = new PendingMessage(this.messageId, this.consumer, this.msSinceLastDelivery, integer);
        this.messageId = null;
        this.consumer = null;
        this.msSinceLastDelivery = null;
        this.subscriber.onNext((Collection)this.output, message);
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(count);
            this.initialized = true;
        }
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<PendingMessage> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<PendingMessage> getSubscriber() {
        return this.subscriber;
    }
}

