/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.output;

import com.grinderwolf.swm.internal.lettuce.core.codec.RedisCodec;
import com.grinderwolf.swm.internal.lettuce.core.output.CommandOutput;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapOutput<K, V>
extends CommandOutput<K, V, Map<K, V>> {
    private boolean initialized;
    private K key;

    public MapOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyMap());
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.key == null) {
            this.key = bytes == null ? null : this.codec.decodeKey(bytes);
            return;
        }
        Object value = bytes == null ? null : (Object)this.codec.decodeValue(bytes);
        ((Map)this.output).put(this.key, value);
        this.key = null;
    }

    @Override
    public void set(long integer) {
        if (this.key == null) {
            this.key = integer;
            return;
        }
        Long value = integer;
        ((Map)this.output).put(this.key, value);
        this.key = null;
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = new LinkedHashMap(count / 2, 1.0f);
            this.initialized = true;
        }
    }
}

