/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.output;

import com.grinderwolf.swm.internal.lettuce.core.KeyValue;
import com.grinderwolf.swm.internal.lettuce.core.codec.RedisCodec;
import com.grinderwolf.swm.internal.lettuce.core.output.CommandOutput;
import com.grinderwolf.swm.internal.lettuce.core.output.OutputFactory;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;

public class KeyValueValueListOutput<K, V>
extends CommandOutput<K, V, KeyValue<K, List<V>>> {
    private K key;
    private List<V> values = Collections.emptyList();

    public KeyValueValueListOutput(RedisCodec<K, V> codec) {
        super(codec, null);
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (bytes != null) {
            if (this.key == null) {
                this.key = this.codec.decodeKey(bytes);
            } else {
                Object value = this.codec.decodeValue(bytes);
                this.values.add(value);
            }
        }
    }

    @Override
    public void multi(int count) {
        this.values = OutputFactory.newList(count);
    }

    @Override
    public void complete(int depth) {
        if (depth == 0 && this.key != null) {
            this.output = KeyValue.just(this.key, this.values);
        }
    }
}

