/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.output;

import com.grinderwolf.swm.internal.lettuce.core.codec.RedisCodec;
import com.grinderwolf.swm.internal.lettuce.core.output.CommandOutput;
import com.grinderwolf.swm.internal.lettuce.core.output.KeyValueStreamingChannel;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class KeyValueStreamingOutput<K, V>
extends CommandOutput<K, V, Long> {
    private Iterable<K> keys;
    private Iterator<K> keyIterator;
    private K key;
    private KeyValueStreamingChannel<K, V> channel;

    public KeyValueStreamingOutput(RedisCodec<K, V> codec, KeyValueStreamingChannel<K, V> channel) {
        super(codec, 0L);
        this.channel = channel;
    }

    public KeyValueStreamingOutput(RedisCodec<K, V> codec, KeyValueStreamingChannel<K, V> channel, Iterable<K> keys) {
        super(codec, 0L);
        this.channel = channel;
        this.keys = keys;
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.keys == null) {
            if (this.key == null) {
                this.key = this.codec.decodeKey(bytes);
                return;
            }
        } else {
            if (this.keyIterator == null) {
                this.keyIterator = this.keys.iterator();
            }
            this.key = this.keyIterator.next();
        }
        Object value = bytes == null ? null : (Object)this.codec.decodeValue(bytes);
        this.channel.onKeyValue(this.key, value);
        this.output = (Long)this.output + 1L;
        this.key = null;
    }
}

