/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.output;

import com.grinderwolf.swm.internal.lettuce.core.codec.RedisCodec;
import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceAssert;
import com.grinderwolf.swm.internal.lettuce.core.output.CommandOutput;
import com.grinderwolf.swm.internal.lettuce.core.output.ListSubscriber;
import com.grinderwolf.swm.internal.lettuce.core.output.OutputFactory;
import com.grinderwolf.swm.internal.lettuce.core.output.StreamingOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class BooleanListOutput<K, V>
extends CommandOutput<K, V, List<Boolean>>
implements StreamingOutput<Boolean> {
    private boolean initialized;
    private StreamingOutput.Subscriber<Boolean> subscriber;

    public BooleanListOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
        this.setSubscriber((StreamingOutput.Subscriber<Boolean>)ListSubscriber.instance());
    }

    @Override
    public void set(long integer) {
        this.subscriber.onNext((Collection)this.output, integer == 1L ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(count);
            this.initialized = true;
        }
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<Boolean> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<Boolean> getSubscriber() {
        return this.subscriber;
    }
}

