/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.masterreplica;

import com.grinderwolf.swm.internal.lettuce.core.RedisClient;
import com.grinderwolf.swm.internal.lettuce.core.RedisException;
import com.grinderwolf.swm.internal.lettuce.core.RedisURI;
import com.grinderwolf.swm.internal.lettuce.core.codec.RedisCodec;
import com.grinderwolf.swm.internal.lettuce.core.event.jfr.EventRecorder;
import com.grinderwolf.swm.internal.lettuce.core.masterreplica.MasterReplicaChannelWriter;
import com.grinderwolf.swm.internal.lettuce.core.masterreplica.MasterReplicaConnectionProvider;
import com.grinderwolf.swm.internal.lettuce.core.masterreplica.MasterReplicaConnector;
import com.grinderwolf.swm.internal.lettuce.core.masterreplica.MasterReplicaTopologyChangedEvent;
import com.grinderwolf.swm.internal.lettuce.core.masterreplica.MasterReplicaTopologyRefresh;
import com.grinderwolf.swm.internal.lettuce.core.masterreplica.StatefulRedisMasterReplicaConnection;
import com.grinderwolf.swm.internal.lettuce.core.masterreplica.StatefulRedisMasterReplicaConnectionImpl;
import com.grinderwolf.swm.internal.lettuce.core.masterreplica.StaticMasterReplicaTopologyProvider;
import com.grinderwolf.swm.internal.lettuce.core.models.role.RedisNodeDescription;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import reactor.core.publisher.Mono;

class StaticMasterReplicaConnector<K, V>
implements MasterReplicaConnector<K, V> {
    private final RedisClient redisClient;
    private final RedisCodec<K, V> codec;
    private final Iterable<RedisURI> redisURIs;

    StaticMasterReplicaConnector(RedisClient redisClient, RedisCodec<K, V> codec, Iterable<RedisURI> redisURIs) {
        this.redisClient = redisClient;
        this.codec = codec;
        this.redisURIs = redisURIs;
    }

    @Override
    public CompletableFuture<StatefulRedisMasterReplicaConnection<K, V>> connectAsync() {
        HashMap initialConnections = new HashMap();
        StaticMasterReplicaTopologyProvider topologyProvider = new StaticMasterReplicaTopologyProvider(this.redisClient, this.redisURIs);
        RedisURI seedNode = this.redisURIs.iterator().next();
        MasterReplicaTopologyRefresh refresh = new MasterReplicaTopologyRefresh(this.redisClient, topologyProvider);
        MasterReplicaConnectionProvider<K, V> connectionProvider = new MasterReplicaConnectionProvider<K, V>(this.redisClient, this.codec, seedNode, initialConnections);
        return refresh.getNodes(seedNode).flatMap(nodes -> {
            EventRecorder.getInstance().record(new MasterReplicaTopologyChangedEvent(seedNode, (List<RedisNodeDescription>)nodes));
            if (nodes.isEmpty()) {
                return Mono.error(new RedisException(String.format("Cannot determine topology from %s", this.redisURIs)));
            }
            return this.initializeConnection(this.codec, seedNode, connectionProvider, (List<RedisNodeDescription>)nodes);
        }).onErrorMap(ExecutionException.class, Throwable::getCause).toFuture();
    }

    private Mono<StatefulRedisMasterReplicaConnection<K, V>> initializeConnection(RedisCodec<K, V> codec, RedisURI seedNode, MasterReplicaConnectionProvider<K, V> connectionProvider, List<RedisNodeDescription> nodes) {
        connectionProvider.setKnownNodes(nodes);
        MasterReplicaChannelWriter channelWriter = new MasterReplicaChannelWriter(connectionProvider, this.redisClient.getResources());
        StatefulRedisMasterReplicaConnectionImpl<K, V> connection = new StatefulRedisMasterReplicaConnectionImpl<K, V>(channelWriter, codec, seedNode.getTimeout());
        connection.setOptions(this.redisClient.getOptions());
        return Mono.just(connection);
    }
}

